/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mariadb.jdbc.MySQLBlob;
import org.mariadb.jdbc.MySQLClob;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLResultSetMetaData;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.ValueObject;
import org.mariadb.jdbc.internal.common.queryresults.CachedSelectResult;
import org.mariadb.jdbc.internal.common.queryresults.ColumnNameMap;
import org.mariadb.jdbc.internal.common.queryresults.NoSuchColumnException;
import org.mariadb.jdbc.internal.common.queryresults.QueryResult;
import org.mariadb.jdbc.internal.common.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.common.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.common.queryresults.StreamingSelectResult;
import org.mariadb.jdbc.internal.mysql.MySQLColumnInformation;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;
import org.mariadb.jdbc.internal.mysql.MySQLType;
import org.mariadb.jdbc.internal.mysql.MySQLValueObject;

public class MySQLResultSet
implements ResultSet {
    public static final MySQLResultSet EMPTY = MySQLResultSet.createEmptyResultSet();
    private QueryResult queryResult;
    private Statement statement;
    private MySQLProtocol protocol;
    private boolean lastGetWasNull;
    private boolean warningsCleared;
    ColumnNameMap columnNameMap;

    protected MySQLResultSet() {
    }

    public MySQLResultSet(QueryResult dqr, Statement statement, MySQLProtocol protocol) {
        this.queryResult = dqr;
        this.statement = statement;
        this.protocol = protocol;
        this.columnNameMap = new ColumnNameMap(dqr.getColumnInformation());
    }

    private static MySQLResultSet createEmptyResultSet() {
        MySQLColumnInformation[] colList = new MySQLColumnInformation[]{};
        List<ValueObject[]> voList = Collections.emptyList();
        CachedSelectResult qr = new CachedSelectResult(colList, voList, 0);
        return new MySQLResultSet(qr, null, null);
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this.queryResult.getResultSetType() == ResultSetType.SELECT && ((SelectQueryResult)this.queryResult).next();
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
        catch (QueryException qe) {
            throw new SQLException(qe);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.queryResult != null) {
            this.queryResult.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastGetWasNull;
    }

    @Override
    public String getString(int i) throws SQLException {
        return this.getValueObject(i).getString();
    }

    @Override
    public int getInt(int i) throws SQLException {
        return this.getValueObject(i).getInt();
    }

    @Override
    public int getInt(String s) throws SQLException {
        return this.getInt(this.findColumn(s));
    }

    private ValueObject getValueObject(int i) throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            ValueObject vo;
            try {
                vo = ((SelectQueryResult)this.queryResult).getValueObject(i - 1);
            }
            catch (NoSuchColumnException e) {
                throw SQLExceptionMapper.getSQLException(e.getMessage(), e);
            }
            this.lastGetWasNull = vo.isNull();
            return vo;
        }
        throw SQLExceptionMapper.getSQLException("Cannot get data from update-result sets");
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.statement == null || this.warningsCleared) {
            return null;
        }
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Cursors not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new MySQLResultSetMetaData(this.queryResult.getColumnInformation(), this.protocol.datatypeMappingFlags);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getObject(this.protocol.datatypeMappingFlags);
        }
        catch (ParseException e) {
            throw SQLExceptionMapper.getSQLException("Could not get object: " + e.getMessage(), "S1009", e);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            return this.columnNameMap.getIndex(columnLabel) + 1;
        }
        throw SQLExceptionMapper.getSQLException("Cannot get column id of update result sets");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String s = this.getValueObject(columnIndex).getString();
        if (s == null) {
            return null;
        }
        return new StringReader(s);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.queryResult.getResultSetType() == ResultSetType.SELECT && ((SelectQueryResult)this.queryResult).isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.queryResult.getResultSetType() == ResultSetType.SELECT && ((SelectQueryResult)this.queryResult).isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.queryResult.getResultSetType() != ResultSetType.MODIFY && ((SelectQueryResult)this.queryResult).getRowPointer() == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT && this.queryResult instanceof CachedSelectResult) {
            return ((SelectQueryResult)this.queryResult).getRowPointer() == this.queryResult.getRows() - 1;
        }
        throw new SQLFeatureNotSupportedException("isLast is not supported for TYPE_FORWARD_ONLY result sets");
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            if (!(this.queryResult instanceof CachedSelectResult)) {
                throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
            }
            ((SelectQueryResult)this.queryResult).moveRowPointerTo(-1);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Cannot move after last row");
    }

    @Override
    public boolean first() throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            if (!(this.queryResult instanceof CachedSelectResult)) {
                throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
            }
            if (this.queryResult.getRows() > 0) {
                ((SelectQueryResult)this.queryResult).moveRowPointerTo(0);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT && this.queryResult.getRows() > 0) {
            ((SelectQueryResult)this.queryResult).moveRowPointerTo(this.queryResult.getRows() - 1);
            return true;
        }
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            return ((SelectQueryResult)this.queryResult).getRowPointer() + 1;
        }
        return 0;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return false;
        }
        SelectQueryResult sqr = (SelectQueryResult)this.queryResult;
        if (sqr.getRows() > 0) {
            if (row >= 0 && row <= sqr.getRows()) {
                sqr.moveRowPointerTo(row - 1);
                return true;
            }
            if (row < 0) {
                sqr.moveRowPointerTo(sqr.getRows() + row);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        int newPos;
        if (this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return false;
        }
        SelectQueryResult sqr = (SelectQueryResult)this.queryResult;
        if (this.queryResult.getRows() > 0 && (newPos = sqr.getRowPointer() + rows) > -1 && newPos <= this.queryResult.getRows()) {
            sqr.moveRowPointerTo(newPos);
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return false;
        }
        SelectQueryResult sqr = (SelectQueryResult)this.queryResult;
        if (sqr.isBeforeFirst()) {
            return false;
        }
        if (sqr.getRows() >= 0) {
            sqr.moveRowPointerTo(sqr.getRowPointer() - 1);
            return !sqr.isBeforeFirst();
        }
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return this.queryResult instanceof StreamingSelectResult ? 1003 : 1004;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Detecting row updates are not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Detecting inserts are not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Row deletes are not supported");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Row refresh is not supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        byte[] bytes = this.getValueObject(columnIndex).getBytes();
        if (bytes == null) {
            return null;
        }
        return new MySQLBlob(bytes);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        byte[] bytes = this.getValueObject(columnIndex).getBytes();
        if (bytes == null) {
            return null;
        }
        return new MySQLClob(bytes);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Type map getting is not supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Getting REFs not supported");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getDate(cal);
        }
        catch (ParseException e) {
            throw SQLExceptionMapper.getSQLException("Could not parse as date");
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getTime(cal);
        }
        catch (ParseException e) {
            throw SQLExceptionMapper.getSQLException("Could not parse time", e);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            return new Timestamp(this.getValueObject(columnIndex).getTimestamp(cal).getTime());
        }
        catch (ParseException e) {
            throw SQLExceptionMapper.getSQLException("Could not parse timestamp", e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            return new URL(this.getValueObject(columnIndex).getString());
        }
        catch (MalformedURLException e) {
            throw SQLExceptionMapper.getSQLException("Could not parse as URL");
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.queryResult == null) {
            return true;
        }
        return this.queryResult.isClosed();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NString not supported");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NString not supported");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        return this.getValueObject(i).getBoolean();
    }

    @Override
    public byte getByte(int i) throws SQLException {
        return this.getValueObject(i).getByte();
    }

    @Override
    public short getShort(int i) throws SQLException {
        return this.getValueObject(i).getShort();
    }

    @Override
    public long getLong(int i) throws SQLException {
        return this.getValueObject(i).getLong();
    }

    @Override
    public float getFloat(int i) throws SQLException {
        return this.getValueObject(i).getFloat();
    }

    @Override
    public double getDouble(int i) throws SQLException {
        return this.getValueObject(i).getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getValueObject(columnIndex).getBigDecimal();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getDate();
        }
        catch (ParseException e) {
            throw SQLExceptionMapper.getSQLException("Could not parse column as date, was: \"" + this.getValueObject(columnIndex).getString() + "\"", e);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getTime();
        }
        catch (ParseException e) {
            throw SQLExceptionMapper.getSQLException("Could not parse column as time, was: \"" + this.getValueObject(columnIndex).getString() + "\"", e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getTimestamp();
        }
        catch (ParseException e) {
            throw SQLExceptionMapper.getSQLException("Could not parse column as timestamp, was: \"" + this.getValueObject(columnIndex).getString() + "\"", e);
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getInputStream();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getInputStream();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getBinaryInputStream();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T getObject(int arg0, Class<T> arg1) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String arg0, Class<T> arg1) throws SQLException {
        return null;
    }

    static ResultSet createResultSet(String[] columnNames, MySQLType[] columnTypes, String[][] data, MySQLProtocol protocol, boolean findColumnReturnsOne) {
        int N = columnNames.length;
        MySQLColumnInformation[] columns = new MySQLColumnInformation[N];
        for (int i = 0; i < N; ++i) {
            columns[i] = MySQLColumnInformation.create(columnNames[i], columnTypes[i]);
        }
        byte[] BOOL_TRUE = new byte[]{1};
        byte[] BOOL_FALSE = new byte[]{0};
        ArrayList<ValueObject[]> rows = new ArrayList<ValueObject[]>();
        for (String[] rowData : data) {
            ValueObject[] row = new ValueObject[N];
            if (rowData.length != N) {
                throw new RuntimeException("Number of elements in the row != number of columns :" + rowData.length + " vs " + N);
            }
            for (int i = 0; i < N; ++i) {
                byte[] bytes;
                if (rowData[i] == null) {
                    bytes = null;
                } else if (columnTypes[i] == MySQLType.BIT) {
                    bytes = rowData[i].equals("0") ? BOOL_FALSE : BOOL_TRUE;
                } else {
                    try {
                        bytes = rowData[i].getBytes("UTF-8");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("No UTF-8");
                    }
                }
                row[i] = new MySQLValueObject(bytes, columns[i]);
            }
            rows.add(row);
        }
        if (findColumnReturnsOne) {
            return new MySQLResultSet(new CachedSelectResult(columns, rows, 0), null, protocol){

                @Override
                public int findColumn(String name) {
                    return 1;
                }
            };
        }
        return new MySQLResultSet(new CachedSelectResult(columns, rows, 0), null, protocol);
    }

    static ResultSet createResultSet(String[] columnNames, MySQLType[] columnTypes, String[][] data, MySQLProtocol protocol) {
        return MySQLResultSet.createResultSet(columnNames, columnTypes, data, protocol, false);
    }

    static ResultSet createGeneratedKeysResultSet(long lastInsertId, int updateCount, MySQLConnection connection) {
        if (updateCount <= 0) {
            return null;
        }
        int autoIncrementIncrement = 1;
        if (updateCount > 1) {
            autoIncrementIncrement = connection.getAutoIncrementIncrement();
        }
        String[][] data = new String[updateCount][];
        for (int i = 0; i < updateCount; ++i) {
            long id = lastInsertId + (long)(i * autoIncrementIncrement);
            data[i] = new String[]{"" + id};
        }
        return MySQLResultSet.createResultSet(new String[]{"insert_id"}, new MySQLType[]{MySQLType.BIGINT}, data, connection.getProtocol(), true);
    }

    void setStatement(Statement st) {
        this.statement = st;
    }
}

