(ns mathbox.primitives.operator.lerp
  (:require ["mathbox-react" :as box]
            [reagent.core :as r]))

(def ^{:doc "*Linear interpolation of data*

:centeredW `false` (bool) - Centered instead of corner sampling
:centeredX `false` (bool) - Centered instead of corner sampling
:centeredY `false` (bool) - Centered instead of corner sampling
:centeredZ `false` (bool) - Centered instead of corner sampling
:classes `[]` (string array) - Custom classes, e.g. `[\\\"big\\\"]`
:depth `null` (nullable number) - Lerp to depth, e.g. `5`
:height `null` (nullable number) - Lerp to height, e.g. `5`
:id `null` (nullable string) - Unique ID, e.g. `\\\"sampler\\\"`
:items `null` (nullable number) - Lerp to items, e.g. `5`
:paddingW `0` (number) - Number of samples padding
:paddingX `0` (number) - Number of samples padding
:paddingY `0` (number) - Number of samples padding
:paddingZ `0` (number) - Number of samples padding
:size `\\\"absolute\\\"` (mapping) - Scaling mode (relative, absolute)
:source `\\\"<\\\"` (select) - Input source
:width `null` (nullable number) - Lerp to width, e.g. `5`"}
  Lerp
  (r/adapt-react-class box/Lerp))
