/*
 * Decompiled with CFR 0.152.
 */
package org.meshy.jshotgun;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ShotgunServlet
extends HttpServlet {
    private static final long serialVersionUID = -7847588451972338616L;
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    SpookyClassLoader classLoader;
    HttpServlet servlet;
    ReloaderThread reloader;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.lock.readLock().lock();
            while (this.servlet == null || this.classLoader.sawAnythingChange()) {
                this.lock.readLock().unlock();
                this.tearDown();
                this.setUp();
                this.lock.readLock().lock();
            }
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.servlet.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.spawnReloader();
    }

    void setUp() throws ServletException {
        try {
            this.lock.writeLock().lock();
            if (this.servlet == null) {
                Thread thread = Thread.currentThread();
                this.classLoader = new SpookyClassLoader(thread.getContextClassLoader());
                thread.setContextClassLoader(this.classLoader);
                this.servlet = this.loadTarget(this.classLoader);
                this.servlet.init(this.getServletConfig());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void tearDown() {
        try {
            this.lock.writeLock().lock();
            if (this.servlet != null && this.classLoader.sawAnythingChange()) {
                this.servlet.destroy();
                this.servlet = null;
                this.classLoader.close();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void spawnReloader() {
        if (this.reloader == null && this.classLoader.isWatchingAnything()) {
            try {
                this.lock.writeLock().lock();
                if (this.reloader == null && this.classLoader.isWatchingAnything()) {
                    this.reloader = new ReloaderThread();
                    this.reloader.start();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setUp();
    }

    public void destroy() {
        super.destroy();
        try {
            this.lock.writeLock().lock();
            if (this.servlet != null) {
                this.classLoader.close();
                this.servlet.destroy();
                this.servlet = null;
            }
            if (this.reloader != null) {
                this.reloader.interrupt();
                this.reloader = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public HttpServlet loadTarget(ClassLoader classLoader) throws ServletException {
        String target = this.getServletConfig().getInitParameter("org.meshy.jshotgun.target");
        if (target == null) {
            throw new ServletException("org.meshy.jshotgun.target servlet parameter must be set in web.xml. eg\n<init-param><param-name>org.meshy.jshotgun.target</param-name>\n<param-value>org.example.MyServlet</param-value></init-param>");
        }
        try {
            return (HttpServlet)classLoader.loadClass(target).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ServletException("unable to load " + target, (Throwable)e);
        }
    }

    class ReloaderThread
    extends Thread {
        ReloaderThread() {
            this.setName(ReloaderThread.class.getName());
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ShotgunServlet.this.setUp();
                    if (!ShotgunServlet.this.classLoader.waitForChange()) continue;
                    ShotgunServlet.this.tearDown();
                }
            }
            catch (ServletException e) {
                throw new RuntimeException("reloading failed", e);
            }
            catch (InterruptedException interruptedException) {
                ShotgunServlet.this.reloader = null;
                return;
            }
        }
    }

    static class SpookyClassLoader
    extends SecureClassLoader
    implements AutoCloseable {
        final Map<String, Class<?>> classes = new ConcurrentHashMap();
        WatchService watcher;
        boolean changed = false;
        boolean closed = false;

        public SpookyClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Path path = this.pathForClass(name);
            if (path == null) {
                return super.loadClass(name);
            }
            try {
                return this.loadClass(name, path);
            }
            catch (Exception e) {
                throw new ClassNotFoundException(name, e);
            }
        }

        private Class<?> loadClass(String name, Path path) throws Exception {
            if (!this.closed) {
                this.watch(path.getParent());
            }
            byte[] b = Files.readAllBytes(path);
            Class<?> c = this.defineClass(name, b, 0, b.length);
            this.classes.put(name, c);
            return c;
        }

        private void watch(Path dir) throws IOException {
            try {
                if (this.watcher == null) {
                    this.watcher = FileSystems.getDefault().newWatchService();
                }
                dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }

        Path pathForClass(String name) {
            URL url = this.getResource(name.replace('.', '/').concat(".class"));
            if (url != null && "file".equals(url.getProtocol())) {
                try {
                    return Paths.get(url.toURI());
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            return null;
        }

        boolean sawAnythingChange() {
            if (!this.closed && this.watcher != null && this.watcher.poll() != null) {
                this.changed = true;
                this.close();
            }
            return this.changed;
        }

        boolean waitForChange() throws InterruptedException {
            try {
                if (!this.closed && this.watcher != null && this.watcher.take() != null) {
                    this.changed = true;
                    this.close();
                }
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
                // empty catch block
            }
            return this.changed;
        }

        boolean isWatchingAnything() {
            return this.watcher != null;
        }

        @Override
        public synchronized void close() {
            this.closed = true;
            if (this.watcher != null) {
                try {
                    this.watcher.close();
                    this.watcher = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

