/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j;

import com.google.common.base.Optional;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.LinkedList;
import org.apache.commons.codec.binary.Base64;
import org.metastatic.sexp4j.ParseException;
import org.metastatic.sexp4j.StreamingParser;

public class AdvancedStreamingParser
extends StreamingParser {
    private int listDepth = 0;
    private State state = State.ConsumeWhitespace;
    private final LinkedList<Integer> tokens;
    private Optional<Integer> quotedStringLength = Optional.absent();
    private boolean consumingDisplayHint = false;
    private byte[] displayHint = null;
    private static final BitSet quotedStringChars = new BitSet(125);

    public AdvancedStreamingParser(InputStream input) {
        super(input);
        this.tokens = new LinkedList();
    }

    @Override
    public void parse() throws IOException {
        boolean keepGoing = false;
        do {
            switch (this.state) {
                case ConsumeWhitespace: {
                    keepGoing = this.consumeWhitespace();
                    break;
                }
                case StartingSymbolOrVerbatim: {
                    keepGoing = this.consumeStartingSymbolOrVerbatim();
                    break;
                }
                case ConsumeBase64: {
                    keepGoing = this.consumeBase64();
                    break;
                }
                case ConsumeHex: {
                    keepGoing = this.consumeHex();
                    break;
                }
                case ConsumeQuotedString: {
                    keepGoing = this.consumeQuotedString();
                    break;
                }
                case ConsumeSymbol: {
                    keepGoing = this.consumeSymbol();
                }
            }
        } while (keepGoing);
    }

    private boolean consumeWhitespace() throws IOException {
        int b = this.input.read();
        if (b == 40) {
            this.onListBegin();
            ++this.listDepth;
        } else if (b == 41) {
            if (this.listDepth == 0) {
                throw new ParseException("extra ')' in input");
            }
            this.onListEnd();
            --this.listDepth;
        } else {
            if (Character.isWhitespace(b)) {
                return true;
            }
            if (b == 91) {
                if (this.consumingDisplayHint) {
                    throw new ParseException("nested display-hints");
                }
                this.consumingDisplayHint = true;
                return true;
            }
            if (b == 93) {
                if (!this.consumingDisplayHint) {
                    throw new ParseException("unexpected token ']'");
                }
                this.displayHint = new byte[0];
                this.consumingDisplayHint = false;
            } else if (b == 35) {
                this.state = State.ConsumeHex;
            } else if (b == 124) {
                this.state = State.ConsumeBase64;
            } else if (b == 34) {
                this.state = State.ConsumeQuotedString;
            } else if (Character.isDigit(b)) {
                this.tokens.addLast(b);
                this.state = State.StartingSymbolOrVerbatim;
            } else if (Character.isLetter(b)) {
                this.tokens.addLast(b);
                this.state = State.ConsumeSymbol;
            } else {
                if (b < 0) {
                    if (this.listDepth > 0) {
                        throw new ParseException("unbalanced parentheses");
                    }
                    return false;
                }
                throw new ParseException("unexpected token %c", Character.valueOf((char)b));
            }
        }
        return true;
    }

    private boolean consumeStartingSymbolOrVerbatim() throws IOException {
        int b;
        while (Character.isDigit(b = this.input.read())) {
            this.tokens.push(b);
        }
        if (Character.isLetter(b)) {
            this.state = State.ConsumeSymbol;
        } else if (b == 58) {
            int length = this.makeLength();
            byte[] buffer = new byte[length];
            int read = this.input.read(buffer);
            if (read < length) {
                throw new EOFException();
            }
            if (this.consumingDisplayHint) {
                this.displayHint = buffer;
                this.consumeWhitespaceUntil(93);
                this.consumingDisplayHint = false;
            } else {
                this.onAtom(buffer, (Optional<byte[]>)Optional.fromNullable((Object)this.displayHint));
                this.displayHint = null;
            }
            this.state = State.ConsumeWhitespace;
        } else if (b == 34) {
            this.quotedStringLength = Optional.of((Object)this.makeLength());
            this.state = State.ConsumeQuotedString;
        } else if (Character.isWhitespace(b)) {
            this.makeSymbol();
            this.state = State.ConsumeWhitespace;
        } else {
            if (b < 0) {
                throw new ParseException("end-of-file reading symbol");
            }
            throw new ParseException("unexpected token: %c", Character.valueOf((char)b));
        }
        return true;
    }

    private void consumeWhitespaceUntil(int stopchar) throws IOException {
        int ch;
        while ((ch = this.input.read()) != stopchar) {
            if (Character.isWhitespace(ch)) continue;
            if (ch == -1) {
                throw new EOFException();
            }
            throw new ParseException("unexpected token %02x", ch);
        }
    }

    private int makeLength() throws ParseException {
        int length = 0;
        while (!this.tokens.isEmpty()) {
            int i = this.tokens.removeFirst();
            int r = length * 10;
            int next = i - 48;
            if (r < length || r + next < length) {
                throw new ParseException("integer overflow: atom length is greater than 2^31-1");
            }
            length = r + next;
        }
        return length;
    }

    private void makeSymbol() throws IOException {
        byte[] buffer = new byte[this.tokens.size()];
        int i = 0;
        while (!this.tokens.isEmpty()) {
            buffer[i++] = this.tokens.removeFirst().byteValue();
        }
        if (this.consumingDisplayHint) {
            this.displayHint = buffer;
            this.consumingDisplayHint = false;
        } else {
            this.onAtom(buffer, (Optional<byte[]>)Optional.fromNullable((Object)this.displayHint));
            this.displayHint = null;
        }
    }

    private boolean consumeSymbol() throws IOException {
        int b;
        while (Character.isLetterOrDigit(b = this.input.read())) {
            this.tokens.addLast(b);
        }
        if (Character.isWhitespace(b)) {
            this.makeSymbol();
            this.state = State.ConsumeWhitespace;
        } else if (b == 40) {
            this.makeSymbol();
            this.onListBegin();
            ++this.listDepth;
            this.state = State.ConsumeWhitespace;
        } else if (b == 41) {
            if (this.listDepth == 0) {
                throw new ParseException("unbalanced parentheses");
            }
            this.makeSymbol();
            this.onListEnd();
            --this.listDepth;
            this.state = State.ConsumeWhitespace;
        } else if (b == 93 && this.consumingDisplayHint) {
            this.makeSymbol();
            this.state = State.ConsumeWhitespace;
        } else {
            if (b < 0) {
                if (this.listDepth > 0) {
                    throw new EOFException();
                }
                this.makeSymbol();
                this.state = State.ConsumeWhitespace;
                return false;
            }
            throw new ParseException("unexpected token: %c", Character.valueOf((char)b));
        }
        return true;
    }

    private boolean consumeBase64() throws IOException {
        int b;
        ByteBuffer buffer = ByteBuffer.allocate(16);
        while (true) {
            if (Character.isLetterOrDigit(b = this.input.read()) || b == 43 || b == 47 || b == 61) {
                if (buffer.remaining() == 0) {
                    buffer = this.grow(buffer);
                }
                buffer.put((byte)b);
                continue;
            }
            if (!Character.isWhitespace(b)) break;
        }
        if (b == 124) {
            buffer.flip();
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            bytes = Base64.decodeBase64((byte[])bytes);
            if (this.consumingDisplayHint) {
                this.displayHint = bytes;
                this.consumeWhitespaceUntil(93);
                this.consumingDisplayHint = false;
            } else {
                this.onAtom(bytes, (Optional<byte[]>)Optional.fromNullable((Object)this.displayHint));
                this.displayHint = null;
            }
        } else {
            if (b < 0) {
                throw new EOFException();
            }
            throw new ParseException("unexpected token: 0x%x", b);
        }
        this.state = State.ConsumeWhitespace;
        return true;
    }

    private int hexchar(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("unexpected char: " + (char)c);
    }

    private boolean consumeHex() throws IOException {
        int b;
        StringBuilder buffer = new StringBuilder();
        while (true) {
            if (Character.isDigit(b = this.input.read()) || b >= 97 && b <= 102 || b >= 65 && b <= 70) {
                buffer.append((char)b);
                continue;
            }
            if (!Character.isWhitespace(b)) break;
        }
        if (b == 35) {
            if (buffer.length() % 2 == 1) {
                buffer.insert(0, '0');
            }
            byte[] result = new byte[buffer.length() / 2];
            int i = 0;
            for (int j = 0; i + 1 < buffer.length() && j < result.length; ++j) {
                result[j] = (byte)(this.hexchar(buffer.charAt(i)) << 4 | this.hexchar(buffer.charAt(i + 1)));
                i += 2;
            }
            if (this.consumingDisplayHint) {
                this.displayHint = result;
                this.consumeWhitespaceUntil(93);
                this.consumingDisplayHint = false;
            } else {
                this.onAtom(result, (Optional<byte[]>)Optional.fromNullable((Object)this.displayHint));
                this.displayHint = null;
            }
        } else {
            if (b < 0) {
                throw new EOFException();
            }
            throw new ParseException("unexpected token: 0x%x", b);
        }
        this.state = State.ConsumeWhitespace;
        return true;
    }

    private boolean consumeQuotedString() throws IOException {
        int b;
        Optional<Integer> len = this.quotedStringLength;
        this.quotedStringLength = Optional.absent();
        ByteBuffer buffer = ByteBuffer.allocate((Integer)len.or((Object)16));
        LinkedList<Integer> peek = new LinkedList<Integer>();
        block14: while (true) {
            if (quotedStringChars.get(b = peek.isEmpty() ? this.input.read() : ((Integer)peek.removeFirst()).intValue())) {
                buffer = this.doPut(buffer, (byte)b);
                continue;
            }
            if (b != 92) break;
            int e1 = this.input.read();
            switch (e1) {
                case 98: {
                    buffer = this.doPut(buffer, (byte)8);
                    break;
                }
                case 116: {
                    buffer = this.doPut(buffer, (byte)9);
                    break;
                }
                case 118: {
                    buffer = this.doPut(buffer, (byte)11);
                    break;
                }
                case 110: {
                    buffer = this.doPut(buffer, (byte)10);
                    break;
                }
                case 114: {
                    buffer = this.doPut(buffer, (byte)13);
                    break;
                }
                case 34: {
                    buffer = this.doPut(buffer, (byte)34);
                    break;
                }
                case 39: {
                    buffer = this.doPut(buffer, (byte)39);
                    break;
                }
                case 92: {
                    buffer = this.doPut(buffer, (byte)92);
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int e2 = this.input.read();
                    int e3 = this.input.read();
                    if (e2 < 48 || e2 > 55 || e3 < 48 || e3 > 55) {
                        throw new ParseException("invalid octal value in quoted string");
                    }
                    int value = e1 - 48 << 6 | e2 - 48 << 3 | e3 - 48;
                    buffer = this.doPut(buffer, (byte)value);
                    break;
                }
                case 120: {
                    int e2 = this.input.read();
                    int e3 = this.input.read();
                    int value = this.hexchar(e2) << 4 | this.hexchar(e3);
                    buffer = this.doPut(buffer, (byte)value);
                    break;
                }
                case 13: {
                    int e2 = this.input.read();
                    if (e2 == 10) continue block14;
                    peek.addLast(e2);
                    break;
                }
                case 10: {
                    int e2 = this.input.read();
                    if (e2 == 13) continue block14;
                    peek.addLast(e2);
                    break;
                }
                default: {
                    throw new ParseException("invalid escape character: %c (0x%x)", Character.valueOf((char)e1), e1);
                }
            }
        }
        if (b == 34) {
            buffer.flip();
            if (len.isPresent() && ((Integer)len.get()).intValue() != buffer.remaining()) {
                throw new ParseException("quoted string length did not match explicit length");
            }
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            if (this.consumingDisplayHint) {
                this.displayHint = bytes;
                this.consumeWhitespaceUntil(93);
                this.consumingDisplayHint = false;
            } else {
                this.onAtom(bytes, (Optional<byte[]>)Optional.fromNullable((Object)this.displayHint));
                this.displayHint = null;
            }
        } else {
            if (b < 0) {
                throw new EOFException();
            }
            throw new ParseException("invalid character in quoted string: %c (0x%x)", Character.valueOf((char)b), b);
        }
        this.state = State.ConsumeWhitespace;
        return true;
    }

    private ByteBuffer doPut(ByteBuffer buffer, byte value) {
        if (!buffer.hasRemaining()) {
            buffer = this.grow(buffer);
        }
        buffer.put(value);
        return buffer;
    }

    private ByteBuffer grow(ByteBuffer buffer) {
        buffer.flip();
        int newLength = buffer.remaining() > 4096 ? buffer.remaining() + 1024 : buffer.remaining() * 2;
        ByteBuffer newBuffer = ByteBuffer.allocate(newLength);
        newBuffer.put(buffer);
        return newBuffer;
    }

    static {
        quotedStringChars.set(48, 58);
        quotedStringChars.set(97, 123);
        quotedStringChars.set(65, 91);
        quotedStringChars.set(32);
        quotedStringChars.set(9);
        quotedStringChars.set(10);
        quotedStringChars.set(13);
        quotedStringChars.set(45);
        quotedStringChars.set(46);
        quotedStringChars.set(47);
        quotedStringChars.set(95);
        quotedStringChars.set(58);
        quotedStringChars.set(42);
        quotedStringChars.set(43);
        quotedStringChars.set(61);
        quotedStringChars.set(40);
        quotedStringChars.set(41);
        quotedStringChars.set(91);
        quotedStringChars.set(93);
        quotedStringChars.set(123);
        quotedStringChars.set(125);
        quotedStringChars.set(124);
        quotedStringChars.set(35);
        quotedStringChars.set(38);
    }

    private static enum State {
        ConsumeWhitespace,
        StartingSymbolOrVerbatim,
        ConsumeSymbol,
        ConsumeQuotedString,
        ConsumeHex,
        ConsumeBase64;

    }
}

