/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import org.metastatic.sexp4j.Atom;
import org.metastatic.sexp4j.DisplayHint;
import org.metastatic.sexp4j.Expression;
import org.metastatic.sexp4j.ExpressionList;
import org.metastatic.sexp4j.Writer;

public class AdvancedWriter
implements Writer {
    private final Optional<Integer> lineLength;
    private final Optional<Integer> indentAmount;
    private final OutputStream outputStream;
    private LastWritten lastWritten = LastWritten.None;
    private int currentLineLength = 0;
    private int indentLevel = 0;

    private AdvancedWriter(Optional<Integer> lineLength, Optional<Integer> indentAmount, OutputStream outputStream) {
        Preconditions.checkNotNull(lineLength);
        Preconditions.checkNotNull(indentAmount);
        Preconditions.checkNotNull((Object)outputStream);
        this.lineLength = lineLength;
        this.indentAmount = indentAmount;
        this.outputStream = outputStream;
    }

    public static Builder create() {
        return new Builder();
    }

    private int writeHint(Atom hint) throws IOException {
        int wrote = 0;
        this.outputStream.write(91);
        ++wrote;
        wrote = this.writeAtomBytes(hint, wrote);
        this.outputStream.write(93);
        return ++wrote;
    }

    @Override
    public int writeAtom(Atom atom) throws IOException {
        int wrote = this.indentOrSpace();
        if (atom.displayHint().isPresent()) {
            wrote += this.writeHint(((DisplayHint)atom.displayHint().get()).atom());
        }
        wrote = this.writeAtomBytes(atom, wrote);
        this.currentLineLength += wrote;
        this.lastWritten = LastWritten.Atom;
        return wrote;
    }

    private int writeAtomBytes(Atom atom, int wrote) throws IOException {
        if (atom.canBeSymbol()) {
            atom.writeTo(this.outputStream);
            wrote += atom.length();
        } else if (atom.canBeQuotedString()) {
            this.outputStream.write(34);
            atom.writeTo(this.outputStream);
            this.outputStream.write(34);
            wrote += atom.length() + 2;
        } else if (atom.length() <= 8) {
            this.outputStream.write(35);
            byte[] hex = atom.asHexBytes();
            this.outputStream.write(hex);
            this.outputStream.write(35);
            wrote += hex.length + 2;
        } else {
            byte[] b64 = atom.asBase64Bytes();
            this.outputStream.write(124);
            this.outputStream.write(b64);
            this.outputStream.write(124);
            wrote += b64.length + 2;
        }
        return wrote;
    }

    private int indentOrSpace() throws IOException {
        int wrote = 0;
        if (this.lastWritten == LastWritten.Atom || this.lastWritten == LastWritten.EndList) {
            if (this.lineLength.isPresent() && this.currentLineLength > (Integer)this.lineLength.get()) {
                this.outputStream.write(10);
                this.currentLineLength = -1;
                ++wrote;
                for (int i = 0; i < this.indentLevel; ++i) {
                    for (int j = 0; j < (Integer)this.indentAmount.or((Object)0); ++j) {
                        this.outputStream.write(32);
                        ++wrote;
                    }
                }
            } else {
                this.outputStream.write(32);
                ++wrote;
            }
        }
        return wrote;
    }

    @Override
    public int writeList(ExpressionList list) throws IOException {
        int wrote = this.beginList0();
        for (Expression e : list) {
            wrote += this.writeExpression(e);
        }
        return wrote += this.endList0();
    }

    @Override
    public void beginList() throws IOException {
        this.currentLineLength += this.beginList0();
    }

    private int beginList0() throws IOException {
        int wrote = this.indentOrSpace();
        this.outputStream.write(40);
        this.lastWritten = LastWritten.BeginList;
        ++this.indentLevel;
        return ++wrote;
    }

    @Override
    public void endList() throws IOException {
        this.currentLineLength += this.endList0();
    }

    private int endList0() throws IOException {
        this.outputStream.write(41);
        this.lastWritten = LastWritten.EndList;
        --this.indentLevel;
        return 1;
    }

    @Override
    public int writeExpression(Expression expression) throws IOException {
        Preconditions.checkNotNull((Object)expression);
        if (expression instanceof ExpressionList) {
            return this.writeList((ExpressionList)expression);
        }
        if (expression instanceof Atom) {
            return this.writeAtom((Atom)expression);
        }
        throw new IllegalArgumentException("don't know how to write a " + expression.getClass());
    }

    public static class Builder {
        private Optional<Integer> lineLength = Optional.absent();
        private Optional<Integer> indentAmount = Optional.absent();
        private Optional<OutputStream> outputStream = Optional.absent();

        private Builder() {
        }

        public Optional<Integer> getLineLength() {
            return this.lineLength;
        }

        public Optional<Integer> getIndentAmount() {
            return this.indentAmount;
        }

        public Optional<OutputStream> getOutputStream() {
            return this.outputStream;
        }

        public Builder lineLength(int lineLength) {
            Preconditions.checkArgument((lineLength > 0 ? 1 : 0) != 0);
            this.lineLength = Optional.of((Object)lineLength);
            return this;
        }

        public Builder indentAmount(int indentAmount) {
            Preconditions.checkArgument((indentAmount > 0 ? 1 : 0) != 0);
            this.indentAmount = Optional.of((Object)indentAmount);
            return this;
        }

        public Builder outputStream(OutputStream outputStream) {
            this.outputStream = Optional.of((Object)outputStream);
            return this;
        }

        public AdvancedWriter build() {
            return new AdvancedWriter(this.lineLength, this.indentAmount, (OutputStream)this.outputStream.get());
        }
    }

    private static enum LastWritten {
        None,
        BeginList,
        EndList,
        Atom,
        NewLine;

    }
}

