/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.codec.binary.Base64;
import org.metastatic.sexp4j.DisplayHint;
import org.metastatic.sexp4j.Expression;
import org.metastatic.sexp4j.Primitives;

public class Atom
implements Cloneable,
Expression {
    private final byte[] bytes;
    private final Optional<DisplayHint> displayHint;
    private static final BitSet symbolChars = new BitSet(256);
    private static final BitSet quotedStringChars = new BitSet(256);

    public Atom(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        this.bytes = (byte[])bytes.clone();
        this.displayHint = Optional.absent();
    }

    public Atom(byte code, byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        this.bytes = new byte[bytes.length + 1];
        this.bytes[0] = code;
        System.arraycopy(bytes, 0, this.bytes, 1, bytes.length);
        this.displayHint = Optional.absent();
    }

    public Atom(byte[] bytes, int offset, int length) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((offset > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((offset + length <= bytes.length ? 1 : 0) != 0);
        this.bytes = new byte[length];
        System.arraycopy(bytes, offset, this.bytes, 0, length);
        this.displayHint = Optional.absent();
    }

    private Atom(byte[] bytes, DisplayHint hint) {
        this.bytes = bytes;
        this.displayHint = Optional.of((Object)hint);
    }

    public static Atom atom(byte[] bytes) {
        return new Atom(bytes);
    }

    public static Atom atom(byte[] bytes, int offset, int length) {
        return new Atom(bytes, offset, length);
    }

    public static Atom atom(String string, Charset charset) {
        return new Atom(string.getBytes(charset));
    }

    public static Atom atom(String string) {
        return Atom.atom(string, Charset.forName("UTF-8"));
    }

    public static Atom atom(byte value) {
        return new Atom(new byte[]{value});
    }

    public static Atom atom(char value) {
        return Atom.atom((short)value);
    }

    public static Atom atom(char value, ByteOrder order) {
        return Atom.atom((short)value, order);
    }

    public static Atom atom(short value, ByteOrder order) {
        return new Atom(Primitives.bytes(value, order));
    }

    public static Atom atom(short value) {
        return new Atom(Primitives.bytes(value));
    }

    public static Atom atom(int value, ByteOrder order) {
        return new Atom(Primitives.bytes(value, order));
    }

    public static Atom atom(int value) {
        return Atom.atom(value, ByteOrder.BIG_ENDIAN);
    }

    public static Atom atom(long value, ByteOrder order) {
        return new Atom(Primitives.bytes(value, order));
    }

    public static Atom atom(long value) {
        return Atom.atom(value, ByteOrder.BIG_ENDIAN);
    }

    public static Atom atom(float value) {
        return new Atom(Primitives.bytes(value));
    }

    public static Atom atom(float value, ByteOrder order) {
        return new Atom(Primitives.bytes(value, order));
    }

    public static Atom atom(double value) {
        return new Atom(Primitives.bytes(value));
    }

    public static Atom atom(double value, ByteOrder order) {
        return new Atom(Primitives.bytes(value, order));
    }

    public byte byteValue() {
        return this.byteValue(0);
    }

    public byte byteValue(int offset) {
        Preconditions.checkState((this.bytes.length - offset == 1 ? 1 : 0) != 0);
        return this.bytes[offset];
    }

    public char charValue() {
        return this.charValue(0);
    }

    public char charValue(int offset) {
        Preconditions.checkState((this.bytes.length - offset == 2 ? 1 : 0) != 0);
        return Primitives.toChar(this.bytes, offset);
    }

    public short shortValue() {
        return this.shortValue(0);
    }

    public short shortValue(int offset) {
        Preconditions.checkState((this.bytes.length - offset == 2 ? 1 : 0) != 0);
        return Primitives.toShort(this.bytes, offset);
    }

    public int intValue() {
        return this.intValue(0);
    }

    public int intValue(int offset) {
        Preconditions.checkState((this.bytes.length - offset == 4 ? 1 : 0) != 0);
        return Primitives.toInt(this.bytes, offset);
    }

    public long longValue() {
        return this.longValue(0);
    }

    public long longValue(int offset) {
        Preconditions.checkState((this.bytes.length - offset == 8 ? 1 : 0) != 0);
        return Primitives.toLong(this.bytes, offset);
    }

    public float floatValue() {
        return this.floatValue(0);
    }

    public float floatValue(int offset) {
        Preconditions.checkState((this.bytes.length - offset == 4 ? 1 : 0) != 0);
        return Primitives.toFloat(this.bytes, offset);
    }

    public double doubleValue() {
        return this.doubleValue(0);
    }

    public double doubleValue(int offset) {
        Preconditions.checkState((this.bytes.length - offset == 8 ? 1 : 0) != 0);
        return Primitives.toDouble(this.bytes, offset);
    }

    public String stringValue() {
        return new String(this.bytes, Charset.forName("UTF-8"));
    }

    public String stringValue(int offset) {
        return new String(this.bytes, offset, this.bytes.length - offset, Charset.forName("UTF-8"));
    }

    public BigInteger bigIntegerValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger bigIntegerValue(int offset) {
        byte[] b = new byte[this.bytes.length - offset];
        System.arraycopy(this.bytes, offset, b, 0, b.length);
        return new BigInteger(b);
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.stringValue());
    }

    public BigDecimal bigDecimalValue(int offset) {
        return new BigDecimal(this.stringValue(offset));
    }

    public Atom withHint(String displayHint) {
        return new Atom(this.bytes, new DisplayHint(displayHint));
    }

    public Atom withHint(Atom displayHint) {
        Preconditions.checkArgument((!displayHint.displayHint().isPresent() ? 1 : 0) != 0, (Object)"Recursive display hints not admissible");
        return new Atom(this.bytes, new DisplayHint(displayHint));
    }

    public Atom withHint(byte displayHint) {
        return new Atom(this.bytes, new DisplayHint(Atom.atom(displayHint)));
    }

    public Optional<DisplayHint> displayHint() {
        return this.displayHint;
    }

    public byte typeCode() {
        return this.bytes[0];
    }

    public int length() {
        return this.bytes.length;
    }

    public byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    public byte[] bytes(int offset) {
        byte[] b = new byte[this.bytes.length - offset];
        System.arraycopy(this.bytes, offset, b, 0, b.length);
        return b;
    }

    public void writeTo(OutputStream out, int offset, int length) throws IOException {
        out.write(this.bytes, offset, length);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes);
    }

    public boolean canBeSymbol() {
        if (this.bytes.length == 0) {
            return false;
        }
        for (byte b : this.bytes) {
            if (symbolChars.get(b & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public boolean canBeQuotedString() {
        for (byte b : this.bytes) {
            if (quotedStringChars.get(b & 0xFF)) continue;
            return false;
        }
        return true;
    }

    private byte hexByte(int i) {
        if (i >= 0 && i < 10) {
            return (byte)(48 + i);
        }
        return (byte)(97 + (i - 10));
    }

    public byte[] asHexBytes() {
        byte[] result = new byte[this.bytes.length * 2];
        int i = 0;
        for (byte b : this.bytes) {
            int x = b & 0xFF;
            result[i++] = this.hexByte(x >> 4 & 0xF);
            result[i++] = this.hexByte(x & 0xF);
        }
        return result;
    }

    public byte[] asBase64Bytes() {
        return Base64.encodeBase64((byte[])this.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        return obj instanceof Atom && Arrays.equals(this.bytes, ((Atom)obj).bytes);
    }

    public String toString() {
        return String.format("%s [bytes: %d bytes long]", super.toString(), this.bytes.length);
    }

    public Atom clone() throws CloneNotSupportedException {
        return (Atom)super.clone();
    }

    static {
        symbolChars.set(97, 123);
        symbolChars.set(65, 91);
        symbolChars.set(48, 58);
        quotedStringChars.set(32);
        quotedStringChars.set(33);
        quotedStringChars.set(35, 127);
    }
}

