/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j;

import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.metastatic.sexp4j.ParseException;
import org.metastatic.sexp4j.StreamingParser;

public class CanonicalStreamingParser
extends StreamingParser {
    private byte[] displayHint = null;

    public CanonicalStreamingParser(InputStream input) {
        super(input);
    }

    @Override
    public void parse() throws IOException {
        int ch;
        while ((ch = this.input.read()) != -1) {
            int len;
            if (ch == 40) {
                this.onListBegin();
                continue;
            }
            if (ch == 41) {
                this.onListEnd();
                continue;
            }
            if (ch == 91) {
                len = this.readLength(this.input.read());
                this.displayHint = new byte[len];
                ByteStreams.readFully((InputStream)this.input, (byte[])this.displayHint);
                if (this.input.read() == 93) continue;
                throw new ParseException("missing display hint terminator");
            }
            if (Character.isDigit(ch)) {
                len = this.readLength(ch);
                byte[] buffer = new byte[len];
                ByteStreams.readFully((InputStream)this.input, (byte[])buffer);
                this.onAtom(buffer, (Optional<byte[]>)Optional.fromNullable((Object)this.displayHint));
                this.displayHint = null;
                continue;
            }
            if (Character.isWhitespace(ch)) continue;
            throw new ParseException("invalid character in stream: %c", ch);
        }
    }

    private int readLength(int char1) throws IOException {
        int ch;
        int result = char1 - 48;
        while ((ch = this.input.read()) != -1 && ch != 58) {
            if (Character.isDigit(ch)) {
                int r = result * 10;
                int next = ch - 48;
                if (r < result || r + next < result) {
                    throw new ParseException("integer overflow: atom length is greater than 2^31-1");
                }
                result = r + next;
                continue;
            }
            throw new ParseException("invalid character in stream: %c", ch);
        }
        return result;
    }
}

