/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.metastatic.sexp4j.Atom;
import org.metastatic.sexp4j.DisplayHint;
import org.metastatic.sexp4j.Expression;
import org.metastatic.sexp4j.ExpressionList;
import org.metastatic.sexp4j.WriteException;
import org.metastatic.sexp4j.Writer;

public class CanonicalWriter
implements Writer {
    private final OutputStream out;
    private int listDepth = 0;
    private WriteType firstWrite = WriteType.None;

    public CanonicalWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public int writeAtom(Atom atom) throws IOException {
        if (this.firstWrite == WriteType.Atom) {
            throw new WriteException("already wrote an atom as the first value");
        }
        int length = 0;
        if (atom.displayHint().isPresent()) {
            Atom hintAtom = ((DisplayHint)atom.displayHint().get()).atom();
            this.out.write(91);
            byte[] hintLengthTag = String.format(Locale.ENGLISH, "%d:", hintAtom.length()).getBytes("UTF-8");
            this.out.write(hintLengthTag);
            hintAtom.writeTo(this.out);
            this.out.write(93);
            length += 2 + hintLengthTag.length + hintAtom.length();
        }
        byte[] lengthTag = String.format(Locale.ENGLISH, "%d:", atom.length()).getBytes("UTF-8");
        this.out.write(lengthTag);
        atom.writeTo(this.out);
        if (this.firstWrite == WriteType.None) {
            this.firstWrite = WriteType.Atom;
        }
        return length += lengthTag.length + atom.length();
    }

    @Override
    public int writeList(ExpressionList list) throws IOException {
        if (this.firstWrite == WriteType.Atom) {
            throw new WriteException("already wrote an atom as the first value");
        }
        this.beginList();
        int len = 0;
        for (Expression expr : list) {
            len += this.writeExpression(expr);
        }
        this.endList();
        return 2 + len;
    }

    @Override
    public void beginList() throws IOException {
        if (this.firstWrite == WriteType.Atom) {
            throw new WriteException("already wrote an atom as the first value");
        }
        this.out.write(40);
        if (this.firstWrite == WriteType.None) {
            this.firstWrite = WriteType.List;
        }
        ++this.listDepth;
    }

    @Override
    public void endList() throws IOException {
        if (this.listDepth <= 0) {
            throw new WriteException("can't end list, list not started");
        }
        this.out.write(41);
        --this.listDepth;
    }

    @Override
    public int writeExpression(Expression expression) throws IOException {
        Preconditions.checkNotNull((Object)expression);
        if (expression instanceof Atom) {
            return this.writeAtom((Atom)expression);
        }
        if (expression instanceof ExpressionList) {
            return this.writeList((ExpressionList)expression);
        }
        throw new IllegalArgumentException("unknown expression of type " + expression.getClass().getName());
    }

    private static enum WriteType {
        None,
        List,
        Atom;

    }
}

