/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j;

import com.google.common.base.Optional;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.metastatic.sexp4j.Atom;
import org.metastatic.sexp4j.Expression;
import org.metastatic.sexp4j.ExpressionList;

public class ExpressionBuilder {
    private final LinkedList<ExpressionList> stack = new LinkedList();
    private Optional<Expression> first = Optional.absent();

    public static ExpressionBuilder create() {
        return new ExpressionBuilder();
    }

    public Expression build() {
        if (this.first.isPresent()) {
            this.stack.clear();
            return (Expression)this.first.get();
        }
        throw new IllegalStateException("nothing to build");
    }

    public ExpressionBuilder atom(Atom atom) {
        if (this.first.isPresent() && this.first.get() instanceof Atom) {
            throw new IllegalStateException("first expression added was an atom");
        }
        if (this.stack.isEmpty()) {
            if (this.first.isPresent()) {
                throw new IllegalStateException("attempt to add atom outside of list");
            }
            this.first = Optional.of((Object)atom);
        } else {
            this.stack.peek().add(atom);
        }
        return this;
    }

    public ExpressionBuilder atom(byte[] atomBytes) {
        return this.atom(new Atom(atomBytes));
    }

    public ExpressionBuilder atom(byte[] atomBytes, int offset, int length) {
        return this.atom(new Atom(atomBytes, offset, length));
    }

    public ExpressionBuilder atom(String atomString) {
        return this.atom(atomString.getBytes());
    }

    public ExpressionBuilder atom(String atomString, Charset charset) {
        return this.atom(atomString.getBytes(charset));
    }

    public ExpressionBuilder atom(String atomString, String atomCharset) throws UnsupportedEncodingException {
        return this.atom(atomString.getBytes(atomCharset));
    }

    public ExpressionBuilder beginList() {
        if (this.first.isPresent() && this.first.get() instanceof Atom) {
            throw new IllegalStateException("first expression added was an atom");
        }
        ExpressionList list = new ExpressionList();
        if (this.stack.isEmpty()) {
            if (this.first.isPresent()) {
                throw new IllegalStateException("attempt to begin list outside of list");
            }
            this.first = Optional.of((Object)list);
        } else {
            this.stack.peek().add(list);
        }
        this.stack.push(list);
        return this;
    }

    public ExpressionBuilder endList() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("no list to end");
        }
        this.stack.pop();
        return this;
    }
}

