/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.LinkedList;
import org.metastatic.sexp4j.Atom;
import org.metastatic.sexp4j.Expression;
import org.metastatic.sexp4j.ExpressionList;
import org.metastatic.sexp4j.ParseException;
import org.metastatic.sexp4j.Parser;
import org.metastatic.sexp4j.StreamingParser;
import org.metastatic.sexp4j.StreamingParserCallback;

public abstract class ParserBase
implements Parser {
    private Optional<Expression> root = Optional.absent();
    private final LinkedList<ExpressionList> stack = new LinkedList();
    private final StreamingParser stream;

    protected ParserBase(StreamingParser parser) {
        this.stream = parser;
        this.stream.addCallback(new Callback());
    }

    @Override
    public Expression parse() throws IOException {
        this.stream.parse();
        return (Expression)this.root.orNull();
    }

    private class Callback
    implements StreamingParserCallback {
        private Callback() {
        }

        @Override
        public void beginList() throws ParseException {
            ExpressionList newList = new ExpressionList();
            if (!ParserBase.this.stack.isEmpty()) {
                ((ExpressionList)ParserBase.this.stack.peek()).add(newList);
            } else {
                if (ParserBase.this.root.isPresent()) {
                    throw new ParseException("found multiple root values");
                }
                ParserBase.this.root = Optional.of((Object)newList);
            }
            ParserBase.this.stack.push(newList);
        }

        @Override
        public void endList() throws ParseException {
            if (ParserBase.this.stack.isEmpty()) {
                throw new ParseException("extraneous end list");
            }
            ParserBase.this.stack.pop();
        }

        @Override
        public void onAtom(byte[] atom, Optional<byte[]> displayHint) throws ParseException {
            Atom a = new Atom(atom);
            if (displayHint.isPresent()) {
                a = a.withHint(new Atom((byte[])displayHint.get()));
            }
            if (ParserBase.this.stack.isEmpty()) {
                if (ParserBase.this.root.isPresent()) {
                    throw new ParseException("found multiple root values");
                }
                ParserBase.this.root = Optional.of((Object)a);
            } else {
                ((ExpressionList)ParserBase.this.stack.peek()).add(a);
            }
        }
    }
}

