/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class Primitives {
    public static byte[] bytes(String string, Charset charset) {
        return string.getBytes(charset);
    }

    public static byte[] bytes(String string) {
        return Primitives.bytes(string, Charset.forName("UTF-8"));
    }

    public static byte[] bytes(short value) {
        return Primitives.bytes(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] bytes(short value, ByteOrder order) {
        byte[] result = new byte[2];
        ByteBuffer.wrap(result).order(order).putShort(value);
        return result;
    }

    public static byte[] bytes(int value, ByteOrder order) {
        byte[] result = new byte[4];
        ByteBuffer.wrap(result).order(order).putInt(value);
        return result;
    }

    public static byte[] bytes(int value) {
        return Primitives.bytes(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] bytes(long value, ByteOrder order) {
        byte[] result = new byte[8];
        ByteBuffer.wrap(result).order(order).putLong(value);
        return result;
    }

    public static byte[] bytes(float value) {
        return Primitives.bytes(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] bytes(float value, ByteOrder order) {
        byte[] result = new byte[4];
        ByteBuffer.wrap(result).order(order).putFloat(value);
        return result;
    }

    public static byte[] bytes(double value) {
        return Primitives.bytes(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] bytes(double value, ByteOrder order) {
        byte[] result = new byte[8];
        ByteBuffer.wrap(result).order(order).putDouble(value);
        return result;
    }

    public static byte[] bytes(long value) {
        return Primitives.bytes(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] bytes(char value) {
        return Primitives.bytes((short)value);
    }

    public static byte[] bytes(char value, ByteOrder order) {
        return Primitives.bytes((short)value, order);
    }

    public static short toShort(byte[] bytes) {
        return Primitives.toShort(bytes, 0);
    }

    public static short toShort(byte[] bytes, int offset) {
        return Primitives.toShort(bytes, offset, ByteOrder.BIG_ENDIAN);
    }

    public static short toShort(byte[] bytes, ByteOrder order) {
        return Primitives.toShort(bytes, 0, order);
    }

    public static short toShort(byte[] bytes, int offset, ByteOrder order) {
        return ByteBuffer.wrap(bytes).order(order).getShort(offset);
    }

    public static int toInt(byte[] bytes, ByteOrder order) {
        return Primitives.toInt(bytes, 0, order);
    }

    public static int toInt(byte[] bytes, int offset, ByteOrder order) {
        return ByteBuffer.wrap(bytes).order(order).getInt(offset);
    }

    public static int toInt(byte[] bytes, int offset) {
        return Primitives.toInt(bytes, offset, ByteOrder.BIG_ENDIAN);
    }

    public static int toInt(byte[] bytes) {
        return Primitives.toInt(bytes, 0);
    }

    public static long toLong(byte[] bytes, int offset, ByteOrder order) {
        return ByteBuffer.wrap(bytes).order(order).getLong(offset);
    }

    public static long toLong(byte[] bytes, ByteOrder order) {
        return Primitives.toLong(bytes, 0, order);
    }

    public static long toLong(byte[] bytes, int offset) {
        return Primitives.toLong(bytes, offset, ByteOrder.BIG_ENDIAN);
    }

    public static long toLong(byte[] bytes) {
        return Primitives.toLong(bytes, 0);
    }

    public static float toFloat(byte[] bytes) {
        return Primitives.toFloat(bytes, ByteOrder.BIG_ENDIAN);
    }

    public static float toFloat(byte[] bytes, ByteOrder order) {
        return Primitives.toFloat(bytes, 0, order);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Primitives.toFloat(bytes, offset, ByteOrder.BIG_ENDIAN);
    }

    public static float toFloat(byte[] bytes, int offset, ByteOrder order) {
        return ByteBuffer.wrap(bytes).order(order).getFloat(offset);
    }

    public static double toDouble(byte[] bytes) {
        return Primitives.toDouble(bytes, ByteOrder.BIG_ENDIAN);
    }

    public static double toDouble(byte[] bytes, ByteOrder order) {
        return Primitives.toDouble(bytes, 0, order);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Primitives.toDouble(bytes, offset, ByteOrder.BIG_ENDIAN);
    }

    public static double toDouble(byte[] bytes, int offset, ByteOrder order) {
        return ByteBuffer.wrap(bytes).order(order).getDouble(offset);
    }

    public static char toChar(byte[] bytes) {
        return (char)Primitives.toShort(bytes);
    }

    public static char toChar(byte[] bytes, ByteOrder order) {
        return (char)Primitives.toShort(bytes, order);
    }

    public static char toChar(byte[] bytes, int offset) {
        return (char)Primitives.toShort(bytes, offset);
    }

    public static char toChar(byte[] bytes, int offset, ByteOrder order) {
        return (char)Primitives.toShort(bytes, offset, order);
    }
}

