/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.metastatic.sexp4j.ParseException;
import org.metastatic.sexp4j.StreamingParserCallback;

public abstract class StreamingParser {
    private final List<StreamingParserCallback> callbacks;
    protected final InputStream input;

    protected StreamingParser(InputStream input) {
        this.input = input;
        this.callbacks = new ArrayList<StreamingParserCallback>();
    }

    public abstract void parse() throws IOException;

    public final void addCallback(StreamingParserCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    public final void removeCallback(StreamingParserCallback callback) {
        this.callbacks.remove(callback);
    }

    protected final void onListBegin() throws ParseException {
        for (StreamingParserCallback callback : this.callbacks) {
            callback.beginList();
        }
    }

    protected final void onListEnd() throws ParseException {
        for (StreamingParserCallback callback : this.callbacks) {
            callback.endList();
        }
    }

    protected final void onAtom(byte[] atom, Optional<byte[]> displayHint) throws ParseException {
        for (StreamingParserCallback callback : this.callbacks) {
            callback.onAtom(atom, displayHint);
        }
    }
}

