/*
 * Decompiled with CFR 0.152.
 */
package org.metastatic.sexp4j.mapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metastatic.sexp4j.Atom;
import org.metastatic.sexp4j.DisplayHint;
import org.metastatic.sexp4j.Expression;
import org.metastatic.sexp4j.ExpressionList;
import org.metastatic.sexp4j.mapper.MapperException;

public class SimpleMapper {
    private Atom atom(byte code, byte[] bytes) {
        return new Atom(code, bytes);
    }

    public Expression encode(Object o) throws MapperException {
        if (o == null) {
            return new Atom(new byte[0]).withHint(Type.Null.code);
        }
        Class<?> clazz = o.getClass();
        if (clazz.equals(Boolean.class)) {
            return new Atom(new byte[]{(Boolean)o != false ? (byte)1 : 0}).withHint(Type.Bool.code);
        }
        if (clazz.equals(Byte.class)) {
            return new Atom(new byte[]{(Byte)o}).withHint(Type.Byte.code);
        }
        if (clazz.equals(Short.class)) {
            return Atom.atom((Short)o).withHint(Type.Short.code);
        }
        if (clazz.equals(Character.class)) {
            return Atom.atom(((Character)o).charValue()).withHint(Type.Char.code);
        }
        if (clazz.equals(Integer.class)) {
            return Atom.atom((Integer)o).withHint(Type.Int.code);
        }
        if (clazz.equals(Long.class)) {
            return Atom.atom((Long)o).withHint(Type.Long.code);
        }
        if (clazz.equals(Float.class)) {
            return Atom.atom(((Float)o).floatValue()).withHint(Type.Float.code);
        }
        if (clazz.equals(Double.class)) {
            return Atom.atom((Double)o).withHint(Type.Double.code);
        }
        if (clazz.equals(String.class)) {
            return Atom.atom((String)o).withHint(Type.String.code);
        }
        if (clazz.equals(BigInteger.class)) {
            return new Atom(((BigInteger)o).toByteArray()).withHint(Type.BigInt.code);
        }
        if (clazz.equals(BigDecimal.class)) {
            return Atom.atom(o.toString()).withHint(Type.BigDecimal.code);
        }
        if (clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE)) {
            return new Atom((byte[])o).withHint(Type.Bytes.code);
        }
        if (List.class.isAssignableFrom(clazz)) {
            ExpressionList list = new ExpressionList(((List)o).size() + 1);
            list.add(Atom.atom(Type.List.code));
            for (Object e : (List)o) {
                list.add(this.encode(e));
            }
            return list;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            ExpressionList list = new ExpressionList(((Set)o).size() + 1);
            list.add(Atom.atom(Type.Set.code));
            for (Object e : (Set)o) {
                list.add(this.encode(e));
            }
            return list;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            ExpressionList list = new ExpressionList(((Map)o).size() * 2 + 1);
            list.add(Atom.atom(Type.Map.code));
            for (Map.Entry e : ((Map)o).entrySet()) {
                Map.Entry entry = e;
                if (!(entry.getKey() instanceof String) || ((String)entry.getKey()).isEmpty()) {
                    throw new MapperException("map keys must be nonempty strings");
                }
                list.add(Atom.atom((String)entry.getKey()));
                list.add(this.encode(e.getValue()));
            }
            return list;
        }
        throw new MapperException("don't know how to encode a " + clazz);
    }

    public Object decode(Expression e) throws MapperException {
        if (e instanceof Atom) {
            int code = 91;
            if (((Atom)e).displayHint().isPresent()) {
                code = ((DisplayHint)((Atom)e).displayHint().get()).atom().typeCode();
            }
            switch (code) {
                case 122: {
                    return ((Atom)e).byteValue() != 0;
                }
                case 110: {
                    return null;
                }
                case 98: {
                    return ((Atom)e).byteValue();
                }
                case 115: {
                    return ((Atom)e).shortValue();
                }
                case 99: {
                    return Character.valueOf(((Atom)e).charValue());
                }
                case 105: {
                    return ((Atom)e).intValue();
                }
                case 108: {
                    return ((Atom)e).longValue();
                }
                case 102: {
                    return Float.valueOf(((Atom)e).floatValue());
                }
                case 100: {
                    return ((Atom)e).doubleValue();
                }
                case 83: {
                    return ((Atom)e).stringValue();
                }
                case 66: {
                    return ((Atom)e).bytes();
                }
                case 73: {
                    return ((Atom)e).bigIntegerValue();
                }
                case 68: {
                    return ((Atom)e).bigDecimalValue();
                }
            }
            throw new MapperException("invalid atom type code: %02x", ((Atom)e).typeCode());
        }
        ExpressionList list = (ExpressionList)e;
        Expression code = list.get(0);
        if (!(code instanceof Atom)) {
            throw new MapperException("expecting type code byte prefixing list");
        }
        switch (((Atom)code).typeCode()) {
            case 108: {
                ArrayList<Object> l = new ArrayList<Object>(list.size() - 1);
                for (Expression ex : list.subList(1, list.size())) {
                    l.add(this.decode(ex));
                }
                return l;
            }
            case 115: {
                LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>(list.size() - 1);
                for (Expression ex : list.subList(1, list.size())) {
                    Object v = this.decode(ex);
                    m.put(v, v);
                }
                return m.keySet();
            }
            case 109: {
                if (list.size() % 2 != 1) {
                    throw new MapperException("maps must have an even number of items");
                }
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(list.size() / 2 + 1);
                int i = 1;
                while (i + 1 < list.size()) {
                    Expression key = list.get(i);
                    if (!(key instanceof Atom) || ((Atom)key).length() == 0) {
                        throw new MapperException("map keys must be nonempty atoms");
                    }
                    Object value = this.decode(list.get(i + 1));
                    m.put(((Atom)key).stringValue(), value);
                    i += 2;
                }
                return m;
            }
        }
        throw new MapperException("invalid type code: 0x%02x", ((Atom)code).typeCode());
    }

    public static enum Type {
        Null(110),
        Bool(122),
        Byte(98),
        Short(115),
        Char(99),
        Int(105),
        Long(108),
        Float(102),
        Double(100),
        String(83),
        BigInt(73),
        BigDecimal(68),
        Bytes(66),
        List(108),
        Set(115),
        Map(109);

        private final byte code;

        private Type(byte code) {
            this.code = code;
        }
    }
}

