(ns micro-business.singlesignon.rootview
  (:require
   [goog.dom :as gdom]
   [om.next :as om :refer-macros [defui]]
   [om.dom :as dom]
   [micro-business.singlesignon.state :as state]
   [micro-business.singlesignon.reader :as reader]
   [micro-business.singlesignon.mutate :as mutate]
   [micro-business.singlesignon.signinpage.rootview :as signinpagerootview]))

(enable-console-print!)

(defui RootView
  static om/IQuery
  (query [this]
         (let [signInPageSubQuery (om/get-query signinpagerootview/SignInPageRootView)]
           `[:current-state {:signin-page ~signInPageSubQuery}]))

  Object
  (render [this]
          (let [{:keys [current-state signin-page]} (om/props this)]
            (case current-state
              :require-signin (signinpagerootview/signInPageRootView signin-page)
              (signinpagerootview/signInPageRootView  signin-page)))))

(def rootViewReconciler
  (om/reconciler
   {:state state/state
    :parser (om/parser {:read reader/read :mutate mutate/mutate})}))

(defn ^:export renderRootView [elementName]
  (om/add-root! rootViewReconciler
                RootView (gdom/getElement elementName)))

(renderRootView "rootView")
