(ns micro-business.uicomponents.uikit.navigationitem
  (:require
   [om.next :as om :refer-macros [defui]]
   [om.dom :as dom]))

(defn getNavItemStyle[id] #js {:key id})

(defn getNavItemLinkStyle [{:keys [href]}]
  (if-let [hrefValue href]
    #js {:href hrefValue}
    #js {}))

(defn getNavItem [{:keys [id caption href]}]
  (dom/li
   (getNavItemStyle id)
   (dom/a (getNavItemLinkStyle {:href href}) caption)))

(defui NavItem
  static om/Ident
  (ident [this {:keys [id]}]
         [:item/by-id id])
  static om/IQuery
  (query [this]
         '[:id :caption :href])
  Object
  (render [this]
          (getNavItem {:caption (-> this om/props :caption)
                       :href (-> this om/props :href)})))

(def navItem (om/factory NavItem))
