/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.input;

import com.mongodb.DBCursor;
import com.mongodb.MongoException;
import com.mongodb.hadoop.input.MongoInputSplit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bson.BSONObject;

public class MongoRecordReader
extends RecordReader<Object, BSONObject> {
    private BSONObject _current;
    private final MongoInputSplit _split;
    private final DBCursor _cursor;
    private float _seen = 0.0f;
    private float _total;
    private static final Log LOG = LogFactory.getLog(MongoRecordReader.class);

    public MongoRecordReader(MongoInputSplit mongoInputSplit) {
        this._split = mongoInputSplit;
        this._cursor = mongoInputSplit.getCursor();
    }

    public void close() {
        if (this._cursor != null) {
            this._cursor.close();
        }
    }

    public Object getCurrentKey() {
        return this._current.get(this._split.getKeyField());
    }

    public BSONObject getCurrentValue() {
        return this._current;
    }

    public float getProgress() {
        try {
            if (this._cursor.hasNext()) {
                return 0.0f;
            }
            return 1.0f;
        }
        catch (MongoException mongoException) {
            return 1.0f;
        }
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        this._total = 1.0f;
    }

    public boolean nextKeyValue() {
        try {
            if (!this._cursor.hasNext()) {
                return false;
            }
            this._current = this._cursor.next();
            this._seen += 1.0f;
            return true;
        }
        catch (MongoException mongoException) {
            return false;
        }
    }
}

