/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.io;

import com.mongodb.hadoop.io.BSONWritable;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.util.Progressable;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

public class BSONFile {
    private static final Log log = LogFactory.getLog(BSONFile.class);

    public static class Writer<K, V>
    implements Closeable {
        Configuration conf;
        FSDataOutputStream out;
        boolean ownOutputStream = true;
        DataOutputBuffer buffer = new DataOutputBuffer();

        Writer() {
        }

        public Writer(FileSystem fileSystem, Configuration configuration, Path path) throws IOException {
            this(fileSystem, configuration, path, fileSystem.getConf().getInt("io.file.buffer.size", 4096), fileSystem.getDefaultReplication(), fileSystem.getDefaultBlockSize(), null);
        }

        public Writer(FileSystem fileSystem, Configuration configuration, Path path, Progressable progressable) throws IOException {
            this(fileSystem, configuration, path, fileSystem.getConf().getInt("io.file.buffer.size", 4096), fileSystem.getDefaultReplication(), fileSystem.getDefaultBlockSize(), progressable);
        }

        public Writer(FileSystem fileSystem, Configuration configuration, Path path, int n, short s, long l, Progressable progressable) throws IOException {
            this.init(path, configuration, fileSystem.create(path, true, n, s, l, progressable));
        }

        void init(Path path, Configuration configuration, FSDataOutputStream fSDataOutputStream) throws IOException {
            this.conf = configuration;
            this.out = fSDataOutputStream;
        }

        public void sync() throws IOException {
        }

        Configuration getConf() {
            return this.conf;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.out != null) {
                if (this.ownOutputStream) {
                    this.out.close();
                } else {
                    this.out.flush();
                }
                this.out = null;
            }
        }

        synchronized void checkAndWriteSync() throws IOException {
            this.sync();
        }

        public synchronized void append(K k, V v) throws IOException {
            BSONWritable bSONWritable = new BSONWritable();
            this.buffer.reset();
            if (k instanceof BSONObject) {
                bSONWritable.put("_id", k);
            } else {
                bSONWritable.put("_id", BSONWritable.toBSON(k));
            }
            if (v instanceof BSONObject) {
                bSONWritable.putAll((BSONObject)v);
            } else {
                bSONWritable.put("value", BSONWritable.toBSON(v));
            }
            if (bSONWritable.get("_id") == null) {
                bSONWritable.removeField("_id");
                bSONWritable.put("_id", new ObjectId());
            }
            bSONWritable.write((DataOutput)this.out);
        }

        public synchronized long getLength() throws IOException {
            return this.out.getPos();
        }
    }
}

