/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred.input;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoURI;
import com.mongodb.hadoop.util.MongoConfigUtil;
import com.mongodb.util.JSON;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;

public class MongoInputSplit
implements Writable,
InputSplit {
    private MongoURI _mongoURI;
    private DBObject _querySpec;
    private DBObject _fieldSpec;
    private DBObject _sortSpec;
    private int _limit = 0;
    private int _skip = 0;
    private long _length = -1L;
    private transient DBCursor _cursor;
    private static final Log log = LogFactory.getLog(MongoInputSplit.class);

    public MongoInputSplit(MongoURI mongoURI, DBObject dBObject, DBObject dBObject2, DBObject dBObject3, int n, int n2) {
        log.info((Object)("Creating a new MongoInputSplit for MongoURI '" + mongoURI + "', query: '" + dBObject + "', fieldSpec: '" + dBObject2 + "', sort: '" + dBObject3 + "', limit: " + n + ", skip: " + n2 + " ."));
        this._mongoURI = mongoURI;
        this._querySpec = dBObject;
        this._fieldSpec = dBObject2;
        this._sortSpec = dBObject3;
        this._limit = n;
        this._skip = n2;
        this.getCursor();
    }

    public MongoInputSplit(com.mongodb.hadoop.input.MongoInputSplit mongoInputSplit) {
        this(mongoInputSplit.getMongoURI(), mongoInputSplit.getQuerySpec(), mongoInputSplit.getFieldSpec(), mongoInputSplit.getSortSpec(), mongoInputSplit.getLimit(), mongoInputSplit.getSkip());
    }

    public long getLength() {
        return Long.MAX_VALUE;
    }

    public String[] getLocations() {
        return this._mongoURI.getHosts().toArray(new String[this._mongoURI.getHosts().size()]);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this._mongoURI.toString());
        dataOutput.writeUTF(JSON.serialize(this._querySpec));
        dataOutput.writeUTF(JSON.serialize(this._fieldSpec));
        dataOutput.writeUTF(JSON.serialize(this._sortSpec));
        dataOutput.writeInt(this._limit);
        dataOutput.writeInt(this._skip);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this._mongoURI = new MongoURI(dataInput.readUTF());
        this._querySpec = (DBObject)JSON.parse(dataInput.readUTF());
        this._fieldSpec = (DBObject)JSON.parse(dataInput.readUTF());
        this._sortSpec = (DBObject)JSON.parse(dataInput.readUTF());
        this._limit = dataInput.readInt();
        this._skip = dataInput.readInt();
        this.getCursor();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deserialized MongoInputSplit ... { length = " + this.getLength() + ", locations = " + Arrays.toString(this.getLocations()) + ", query = " + this._querySpec + ", fields = " + this._fieldSpec + ", sort = " + this._sortSpec + ", limit = " + this._limit + ", skip = " + this._skip + "}"));
        }
    }

    DBCursor getCursor() {
        if (this._cursor == null) {
            this._cursor = MongoConfigUtil.getCollection(this._mongoURI).find(this._querySpec, this._fieldSpec).sort(this._sortSpec);
            this._cursor.slaveOk();
        }
        return this._cursor;
    }

    public String toString() {
        return "MongoInputSplit{URI=" + this._mongoURI + ", query=" + this._querySpec + '}';
    }

    public MongoInputSplit() {
    }
}

