/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred.output;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.MongoException;
import com.mongodb.hadoop.MongoOutput;
import com.mongodb.hadoop.io.BSONWritable;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.bson.BSONObject;

public class MongoRecordWriter<K, V>
implements RecordWriter<K, V> {
    final DBCollection _collection;
    final JobConf _conf;
    private static final Log log = LogFactory.getLog(MongoRecordWriter.class);

    public MongoRecordWriter(DBCollection dBCollection, JobConf jobConf) {
        this._collection = dBCollection;
        this._conf = jobConf;
    }

    public void close(Reporter reporter) {
        this._collection.getDB().getLastError();
    }

    public void write(K k, V v) throws IOException {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Writing out data {k: " + k + ", value:  " + v));
        }
        if (k instanceof MongoOutput) {
            ((MongoOutput)k).appendAsKey(basicDBObject);
        } else if (k instanceof BSONObject) {
            basicDBObject.put("_id", k);
        } else {
            basicDBObject.put("_id", BSONWritable.toBSON(k));
        }
        if (v instanceof MongoOutput) {
            ((MongoOutput)v).appendAsValue(basicDBObject);
        } else if (v instanceof BSONObject) {
            basicDBObject.putAll((BSONObject)v);
        } else {
            basicDBObject.put("value", BSONWritable.toBSON(v));
        }
        try {
            this._collection.save(basicDBObject);
        }
        catch (MongoException mongoException) {
            throw new IOException("can't write to mongo", mongoException);
        }
    }

    public JobConf getConf() {
        return this._conf;
    }
}

