/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.output;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.hadoop.MongoOutput;
import com.mongodb.hadoop.io.BSONWritable;
import java.io.IOException;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bson.BSONObject;

public class MongoRecordWriter<K, V>
extends RecordWriter<K, V> {
    private final String[] updateKeys;
    private final boolean multiUpdate;
    final DBCollection _collection;
    final TaskAttemptContext _context;

    public MongoRecordWriter(DBCollection dBCollection, TaskAttemptContext taskAttemptContext) {
        this(dBCollection, taskAttemptContext, null);
    }

    public MongoRecordWriter(DBCollection dBCollection, TaskAttemptContext taskAttemptContext, String[] stringArray) {
        this(dBCollection, taskAttemptContext, stringArray, false);
    }

    public MongoRecordWriter(DBCollection dBCollection, TaskAttemptContext taskAttemptContext, String[] stringArray, boolean bl) {
        this._collection = dBCollection;
        this._context = taskAttemptContext;
        this.updateKeys = stringArray;
        this.multiUpdate = false;
    }

    public void close(TaskAttemptContext taskAttemptContext) {
        this._collection.getDB().getLastError();
    }

    public void write(K k, V v) throws IOException {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (k instanceof MongoOutput) {
            ((MongoOutput)k).appendAsKey(basicDBObject);
        } else if (k instanceof BSONObject) {
            basicDBObject.put("_id", k);
        } else {
            basicDBObject.put("_id", BSONWritable.toBSON(k));
        }
        if (v instanceof MongoOutput) {
            ((MongoOutput)v).appendAsValue(basicDBObject);
        } else if (v instanceof BSONObject) {
            basicDBObject.putAll((BSONObject)v);
        } else {
            basicDBObject.put("value", BSONWritable.toBSON(v));
        }
        try {
            if (this.updateKeys == null) {
                this._collection.save(basicDBObject);
            } else {
                BasicDBObject basicDBObject2 = new BasicDBObject(this.updateKeys.length);
                for (String string : this.updateKeys) {
                    basicDBObject2.put(string, basicDBObject.get(string));
                    basicDBObject.removeField(string);
                }
                if (basicDBObject.get("_id") == null) {
                    basicDBObject.removeField("_id");
                }
                BasicDBObject basicDBObject3 = new BasicDBObject().append("$set", basicDBObject);
                this._collection.update(basicDBObject2, basicDBObject3, true, this.multiUpdate);
            }
        }
        catch (MongoException mongoException) {
            throw new IOException("can't write to mongo", mongoException);
        }
    }

    public void ensureIndex(DBObject dBObject, DBObject dBObject2) {
        this._collection.ensureIndex(dBObject, dBObject2);
    }

    public TaskAttemptContext getContext() {
        return this._context;
    }
}

