/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import com.mongodb.hadoop.MongoConfig;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.util.MongoConfigUtil;
import com.mongodb.hadoop.util.SplitFriendlyDBCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.bson.BasicBSONObject;

public class MongoSplitter {
    private static final Log log = LogFactory.getLog(MongoSplitter.class);

    public static List<InputSplit> calculateSplits(MongoConfig mongoConfig) {
        if (mongoConfig.getLimit() > 0 || mongoConfig.getSkip() > 0) {
            throw new IllegalArgumentException("skip() and limit() is not currently supported due to input split issues.");
        }
        MongoURI mongoURI = mongoConfig.getInputURI();
        DBCollection dBCollection = MongoConfigUtil.getCollection(mongoURI);
        DB dB = dBCollection.getDB();
        Mongo mongo = dB.getMongo();
        CommandResult commandResult = dBCollection.getStats();
        boolean bl = commandResult.getBoolean("sharded", false);
        boolean bl2 = mongoConfig.canReadSplitsFromShards();
        boolean bl3 = mongoConfig.isShardChunkedSplittingEnabled();
        boolean bl4 = mongoConfig.canReadSplitsFromSecondary();
        log.info((Object)(" Calculate Splits Code ... Use Shards? " + bl2 + ", Use Chunks? " + bl3 + "; Collection Sharded? " + bl));
        if (mongoConfig.createInputSplits()) {
            log.info((Object)"Creation of Input Splits is enabled.");
            if (bl && (bl2 || bl3)) {
                if (bl2 && bl3) {
                    log.warn((Object)"Combining 'use chunks' and 'read from shards directly' can have unexpected & erratic behavior in a live system due to chunk migrations. ");
                }
                log.info((Object)"Sharding mode calculation entering.");
                return MongoSplitter.calculateShardedSplits(mongoConfig, bl2, bl3, bl4, mongoURI, mongo);
            }
            log.info((Object)"Using Unsharded Split mode (Calculating multiple splits though)");
            return MongoSplitter.calculateUnshardedSplits(mongoConfig, bl4, mongoURI, dBCollection);
        }
        log.info((Object)"Creation of Input Splits is disabled; Non-Split mode calculation entering.");
        return MongoSplitter.calculateSingleSplit(mongoConfig);
    }

    private static List<InputSplit> calculateUnshardedSplits(MongoConfig mongoConfig, boolean bl, MongoURI mongoURI, DBCollection dBCollection) {
        ArrayList<InputSplit> arrayList = new ArrayList<InputSplit>();
        DBObject dBObject = mongoConfig.getInputSplitKey();
        int n = mongoConfig.getSplitSize();
        String string = dBCollection.getFullName();
        DBObject dBObject2 = mongoConfig.getQuery();
        log.info((Object)("Calculating unsharded input splits on namespace '" + string + "' with Split Key '" + dBObject.toString() + "' and a split size of '" + n + "'mb per"));
        DBObject dBObject3 = BasicDBObjectBuilder.start("splitVector", string).add("keyPattern", dBObject).add("force", false).add("maxChunkSize", n).get();
        log.trace((Object)("Issuing Command: " + dBObject3));
        CommandResult commandResult = dBCollection.getDB().command(dBObject3);
        if (commandResult.containsField("$err")) {
            throw new IllegalArgumentException("Error calculating splits: " + commandResult);
        }
        if ((Double)commandResult.get("ok") != 1.0) {
            throw new IllegalArgumentException("Unable to calculate input splits: " + (String)commandResult.get("errmsg"));
        }
        BasicDBList basicDBList = (BasicDBList)commandResult.get("splitKeys");
        if (basicDBList.size() <= 1) {
            if (basicDBList.size() < 1) {
                log.warn((Object)"WARNING: No Input Splits were calculated by the split code. Proceeding with a *single* split. Data may be too small, try lowering 'mongo.input.split_size' if this is undesirable.");
            }
            arrayList.add(MongoSplitter._split(mongoConfig, dBObject2, null, null));
        } else {
            log.info((Object)("Calculated " + basicDBList.size() + " splits."));
            DBObject dBObject4 = (DBObject)basicDBList.get(0);
            arrayList.add(MongoSplitter._split(mongoConfig, dBObject2, null, dBObject4));
            for (int i = 1; i < basicDBList.size(); ++i) {
                DBObject dBObject5 = (DBObject)basicDBList.get(i);
                arrayList.add(MongoSplitter._split(mongoConfig, dBObject2, dBObject4, dBObject5));
                dBObject4 = dBObject5;
            }
            arrayList.add(MongoSplitter._split(mongoConfig, dBObject2, dBObject4, null));
        }
        return arrayList;
    }

    private static MongoInputSplit _split(MongoConfig mongoConfig, DBObject dBObject, DBObject dBObject2, DBObject dBObject3) {
        BasicDBObjectBuilder basicDBObjectBuilder = BasicDBObjectBuilder.start("$query", dBObject);
        if (dBObject2 != null) {
            basicDBObjectBuilder.add("$min", dBObject2);
        }
        if (dBObject3 != null) {
            basicDBObjectBuilder.add("$max", dBObject3);
        }
        DBObject dBObject4 = basicDBObjectBuilder.get();
        log.trace((Object)("Assembled Query: " + dBObject4));
        return new MongoInputSplit(mongoConfig.getInputURI(), mongoConfig.getInputKey(), dBObject4, mongoConfig.getFields(), mongoConfig.getSort(), mongoConfig.getLimit(), mongoConfig.getSkip(), mongoConfig.isNoTimeout());
    }

    private static List<InputSplit> calculateSingleSplit(MongoConfig mongoConfig) {
        ArrayList<InputSplit> arrayList = new ArrayList<InputSplit>(1);
        arrayList.add(new MongoInputSplit(mongoConfig.getInputURI(), mongoConfig.getInputKey(), mongoConfig.getQuery(), mongoConfig.getFields(), mongoConfig.getSort(), mongoConfig.getLimit(), mongoConfig.getSkip(), mongoConfig.isNoTimeout()));
        log.info((Object)("Calculated " + arrayList.size() + " split objects."));
        log.debug((Object)"Dump of calculated splits ... ");
        for (InputSplit inputSplit : arrayList) {
            log.debug((Object)("\t Split: " + inputSplit.toString()));
        }
        return arrayList;
    }

    private static List<InputSplit> calculateShardedSplits(MongoConfig mongoConfig, boolean bl, boolean bl2, boolean bl3, MongoURI mongoURI, Mongo mongo) {
        try {
            List<InputSplit> list;
            if (bl2) {
                list = MongoSplitter.fetchSplitsViaChunks(mongoConfig, mongoURI, mongo, bl, bl3);
            } else if (bl) {
                log.warn((Object)"Fetching Input Splits directly from shards is potentially dangerous for data consistency should migrations occur during the retrieval.");
                list = MongoSplitter.fetchSplitsFromShards(mongoConfig, mongoURI, mongo, bl3);
            } else {
                throw new IllegalStateException("Neither useChunks nor useShards enabled; failed to pick a valid state. ");
            }
            if (list == null) {
                throw new IllegalStateException("Failed to create/calculate Input Splits from Shard Chunks; final splits content is 'null'.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calculated splits and returning them - splits: " + list));
            }
            return list;
        }
        catch (Exception exception) {
            log.error((Object)("Could not get splits (use_shards: " + bl + ", use_chunks: " + bl2 + ")"), (Throwable)exception);
            throw new IllegalStateException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<InputSplit> fetchSplitsFromShards(MongoConfig mongoConfig, MongoURI mongoURI, Mongo mongo, Boolean bl) {
        Cloneable cloneable;
        log.warn((Object)"WARNING getting splits that connect directly to the backend mongods is risky and might not produce correct results");
        DB dB = mongo.getDB("config");
        DBCollection dBCollection = dB.getCollection("shards");
        HashSet<Object> hashSet = new HashSet<Object>();
        DBCursor dBCursor = dBCollection.find();
        try {
            while (dBCursor.hasNext()) {
                cloneable = (BasicDBObject)dBCursor.next();
                Object object = ((BasicBSONObject)cloneable).getString("host");
                int n = ((String)object).indexOf(47);
                if (n > 0) {
                    object = ((String)object).substring(n + 1);
                }
                hashSet.add(object);
            }
        }
        finally {
            if (dBCursor != null) {
                dBCursor.close();
            }
            dBCursor = null;
        }
        cloneable = new ArrayList(hashSet.size());
        for (String string : hashSet) {
            MongoURI mongoURI2 = MongoSplitter.getNewURI(mongoURI, string, bl);
            cloneable.add(new MongoInputSplit(mongoURI2, mongoConfig.getInputKey(), mongoConfig.getQuery(), mongoConfig.getFields(), mongoConfig.getSort(), mongoConfig.getLimit(), mongoConfig.getSkip(), mongoConfig.isNoTimeout()));
        }
        return cloneable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<InputSplit> fetchSplitsViaChunks(MongoConfig mongoConfig, MongoURI mongoURI, Mongo mongo, boolean bl, Boolean bl2) {
        int n;
        Object object;
        Object object2;
        DBCollection dBCollection;
        DBObject dBObject = mongoConfig.getQuery();
        if (bl) {
            log.warn((Object)"WARNING getting splits that connect directly to the backend mongods is risky and might not produce correct results");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSplitsUsingChunks(): originalQuery: " + dBObject));
        }
        DB dB = mongo.getDB("config");
        HashMap<String, String> hashMap = null;
        if (bl) {
            hashMap = new HashMap<String, String>();
            dBCollection = dB.getCollection("shards");
            object2 = dBCollection.find();
            try {
                while (((DBCursor)object2).hasNext()) {
                    object = (BasicDBObject)((DBCursor)object2).next();
                    String string = ((BasicBSONObject)object).getString("host");
                    n = string.indexOf(47);
                    if (n > 0) {
                        string = string.substring(n + 1);
                    }
                    hashMap.put((String)((BasicBSONObject)object).get("_id"), string);
                }
            }
            finally {
                if (object2 != null) {
                    ((DBCursor)object2).close();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("MongoInputFormat.getSplitsUsingChunks(): shard map is: " + hashMap));
        }
        dBCollection = dB.getCollection("chunks");
        object2 = new BasicDBObject();
        ((BasicBSONObject)object2).put("ns", (Object)(mongoURI.getDatabase() + "." + mongoURI.getCollection()));
        object = dBCollection.find((DBObject)object2);
        try {
            Cloneable cloneable;
            int n2 = 0;
            n = ((DBCursor)object).size();
            ArrayList<MongoInputSplit> arrayList = new ArrayList<MongoInputSplit>(n);
            while (((DBCursor)object).hasNext()) {
                Object object3;
                ++n2;
                cloneable = (BasicDBObject)((DBCursor)object).next();
                DBObject dBObject2 = (DBObject)((BasicBSONObject)cloneable).get("min");
                BasicDBObject basicDBObject = new BasicDBObject();
                BasicDBObject basicDBObject2 = new BasicDBObject();
                BasicDBObject basicDBObject3 = new BasicDBObject();
                for (String string : dBObject2.keySet()) {
                    object3 = dBObject2.get(string);
                    Object object4 = ((DBObject)((BasicBSONObject)cloneable).get("max")).get(string);
                    if (object3 != SplitFriendlyDBCallback.MIN_KEY_TYPE && !object3.equals("MinKey")) {
                        basicDBObject2.put(string, object3);
                    }
                    if (object4 == SplitFriendlyDBCallback.MAX_KEY_TYPE || object4.equals("MaxKey")) continue;
                    basicDBObject3.put(string, object4);
                }
                if (dBObject == null) {
                    dBObject = new BasicDBObject();
                }
                basicDBObject.put("$min", (Object)basicDBObject2);
                basicDBObject.put("$max", (Object)basicDBObject3);
                basicDBObject.put("$query", (Object)dBObject);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + n2 + "/" + n + "] new query is: " + basicDBObject));
                }
                Object object5 = mongoConfig.getInputURI();
                if (bl) {
                    String string;
                    string = ((BasicBSONObject)cloneable).getString("shard");
                    object3 = (String)hashMap.get(string);
                    object5 = MongoSplitter.getNewURI((MongoURI)object5, (String)object3, bl2);
                }
                arrayList.add(new MongoInputSplit((MongoURI)object5, mongoConfig.getInputKey(), basicDBObject, mongoConfig.getFields(), mongoConfig.getSort(), mongoConfig.getLimit(), mongoConfig.getSkip(), mongoConfig.isNoTimeout()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("MongoInputFormat.getSplitsUsingChunks(): There were " + n2 + " chunks, returning " + arrayList.size() + " splits: " + arrayList));
            }
            cloneable = arrayList;
            return cloneable;
        }
        finally {
            if (object != null) {
                ((DBCursor)object).close();
            }
        }
    }

    private static MongoURI getNewURI(MongoURI mongoURI, String string, Boolean bl) {
        String string2 = mongoURI.toString();
        string2 = string2.substring("mongodb://".length());
        int n = -1;
        int n2 = 0;
        int n3 = string2.lastIndexOf("/");
        n = n3 < 0 ? string2.length() : n3;
        n3 = string2.indexOf("@");
        if (n3 > 0) {
            n2 = n3 + 1;
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.replace(n2, n, string);
        if (bl != null) {
            if (string2.contains("?")) {
                stringBuilder.append("&slaveok=").append(bl);
            } else {
                stringBuilder.append("?slaveok=").append(bl);
            }
        }
        String string3 = "mongodb://" + stringBuilder.toString();
        log.debug((Object)("getNewURI(): original " + mongoURI + " new uri: " + string3));
        return new MongoURI(string3);
    }
}

