/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred;

import com.mongodb.hadoop.MongoConfig;
import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.mapred.input.MongoInputSplit;
import com.mongodb.hadoop.mapred.input.MongoRecordReader;
import com.mongodb.hadoop.util.MongoSplitter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;

public class MongoInputFormat
implements InputFormat<BSONWritable, BSONWritable> {
    private static final Log log = LogFactory.getLog(MongoInputFormat.class);

    public RecordReader<BSONWritable, BSONWritable> getRecordReader(org.apache.hadoop.mapred.InputSplit inputSplit, JobConf jobConf, Reporter reporter) {
        if (!(inputSplit instanceof MongoInputSplit)) {
            throw new IllegalStateException("Creation of a new RecordReader requires a MongoInputSplit instance.");
        }
        MongoInputSplit mongoInputSplit = (MongoInputSplit)inputSplit;
        return new MongoRecordReader(mongoInputSplit);
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf jobConf, int n) {
        MongoConfig mongoConfig = new MongoConfig((Configuration)jobConf);
        List<InputSplit> list = MongoSplitter.calculateSplits(mongoConfig);
        org.apache.hadoop.mapred.InputSplit[] inputSplitArray = new org.apache.hadoop.mapred.InputSplit[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            inputSplitArray[i] = new MongoInputSplit((com.mongodb.hadoop.input.MongoInputSplit)list.get(i));
        }
        return inputSplitArray;
    }

    public boolean verifyConfiguration(Configuration configuration) {
        return true;
    }
}

