/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred.input;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.MongoException;
import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.mapred.input.MongoInputSplit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.bson.BSONObject;

public class MongoRecordReader
implements RecordReader<BSONWritable, BSONWritable> {
    private final DBCursor _cursor;
    private BSONObject _current;
    private float _seen = 0.0f;
    private float _total;
    private static final Log log = LogFactory.getLog(MongoRecordReader.class);

    public MongoRecordReader(MongoInputSplit mongoInputSplit) {
        this._cursor = mongoInputSplit.getCursor();
    }

    public void close() {
        if (this._cursor != null) {
            this._cursor.close();
        }
    }

    public BSONWritable createKey() {
        return new BSONWritable();
    }

    public BSONWritable createValue() {
        return new BSONWritable();
    }

    public BSONObject getCurrentKey() {
        return new BasicDBObject("_id", this._current.get("_id"));
    }

    public BSONObject getCurrentValue() {
        return this._current;
    }

    public float getProgress() {
        try {
            if (this._cursor.hasNext()) {
                return 0.0f;
            }
            return 1.0f;
        }
        catch (MongoException mongoException) {
            return 1.0f;
        }
    }

    public long getPos() {
        return 0L;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        this._total = 1.0f;
    }

    public boolean nextKeyValue() {
        try {
            if (!this._cursor.hasNext()) {
                return false;
            }
            this._current = this._cursor.next();
            this._seen += 1.0f;
            return true;
        }
        catch (MongoException mongoException) {
            return false;
        }
    }

    public boolean next(BSONWritable bSONWritable, BSONWritable bSONWritable2) {
        if (this.nextKeyValue()) {
            log.debug((Object)"Had another k/v");
            bSONWritable.put("_id", this.getCurrentKey().get("_id"));
            bSONWritable2.putAll(this.getCurrentValue());
            return true;
        }
        log.info((Object)"Cursor exhausted.");
        return false;
    }
}

