/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;

public class MongoTool
extends Configured
implements Tool {
    private static final Log log = LogFactory.getLog(MongoTool.class);
    String _jobName = "<unnamed MongoTool job>";

    public int run(String[] stringArray) throws Exception {
        Object object2;
        Configuration configuration = this.getConf();
        log.info((Object)("Created a conf: '" + configuration + "' on {" + ((Object)((Object)this)).getClass() + "} as job named '" + this._jobName + "'"));
        for (Object object2 : configuration) {
            log.trace((Object)String.format("%s=%s\n", object2.getKey(), object2.getValue()));
        }
        Iterator iterator = new Job(configuration, this._jobName);
        iterator.setJarByClass(((Object)((Object)this)).getClass());
        object2 = MongoConfigUtil.getMapper(configuration);
        log.info((Object)("Mapper Class: " + object2));
        iterator.setMapperClass((Class)object2);
        Class<? extends Reducer> clazz = MongoConfigUtil.getCombiner(configuration);
        if (clazz != null) {
            iterator.setCombinerClass(clazz);
        }
        iterator.setReducerClass(MongoConfigUtil.getReducer(configuration));
        iterator.setOutputFormatClass(MongoConfigUtil.getOutputFormat(configuration));
        iterator.setOutputKeyClass(MongoConfigUtil.getOutputKey(configuration));
        iterator.setOutputValueClass(MongoConfigUtil.getOutputValue(configuration));
        iterator.setInputFormatClass(MongoConfigUtil.getInputFormat(configuration));
        boolean bl = MongoConfigUtil.isJobVerbose(configuration);
        boolean bl2 = MongoConfigUtil.isJobBackground(configuration);
        try {
            if (bl2) {
                log.info((Object)"Setting up and running MapReduce job in background.");
                iterator.submit();
                return 0;
            }
            log.info((Object)("Setting up and running MapReduce job in foreground, will wait for results.  {Verbose? " + bl + "}"));
            return iterator.waitForCompletion(true) ? 0 : 1;
        }
        catch (Exception exception) {
            log.error((Object)"Exception while executing job... ", (Throwable)exception);
            return 1;
        }
    }
}

