/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.tree;

import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import mdlaf.components.tree.MaterialTreeCellEditor;
import mdlaf.components.tree.MaterialTreeCellRenderer;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialTreeUI
extends BasicTreeUI {
    public static ComponentUI createUI(JComponent c) {
        return new MaterialTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JTree tree = (JTree)c;
        MaterialTreeCellRenderer renderer = new MaterialTreeCellRenderer();
        MaterialTreeCellEditor editor = new MaterialTreeCellEditor(tree, renderer);
        tree.setCellRenderer(renderer);
        tree.setCellEditor(editor);
        tree.setFont(UIManager.getFont("Tree.font"));
        tree.setRowHeight(0);
        tree.setInvokesStopCellEditing(true);
        MaterialTreeUI ui = (MaterialTreeUI)tree.getUI();
        ui.setLeftChildIndent(10);
        ui.setRightChildIndent(10);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        super.paint(g, c);
    }
}

