/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.utils;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class MaterialFonts {
    private static final Map<TextAttribute, Object> fontSettings = new HashMap<TextAttribute, Object>();
    public static final Font BLACK = MaterialFonts.loadFont("/fonts/NotoSans-Black.ttf");
    public static final Font BLACK_ITALIC = MaterialFonts.loadFont("/fonts/NotoSans-BlackItalic.ttf");
    public static final Font BOLD = MaterialFonts.loadFont("/fonts/NotoSans-Bold.ttf");
    public static final Font BOLD_ITALIC = MaterialFonts.loadFont("/fonts/NotoSans-BoldItalic.ttf");
    public static final Font ITALIC = MaterialFonts.loadFont("/fonts/NotoSans-Italic.ttf");
    public static final Font LIGHT = MaterialFonts.loadFont("/fonts/NotoSans-Light.ttf");
    public static final Font LIGHT_ITALIC = MaterialFonts.loadFont("/fonts/NotoSans-LightItalic.ttf");
    public static final Font MEDIUM = MaterialFonts.loadFont("/fonts/NotoSans-Medium.ttf");
    public static final Font MEDIUM_ITALIC = MaterialFonts.loadFont("/fonts/NotoSans-MediumItalic.ttf");
    public static final Font REGULAR = MaterialFonts.loadFont("/fonts/NotoSans-Regular.ttf");
    public static final Font THIN = MaterialFonts.loadFont("/fonts/NotoSans-Thin.ttf");
    public static final Font THIN_ITALIC = MaterialFonts.loadFont("/fonts/NotoSans-ThinItalic.ttf");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Font loadFont(String fontPath) {
        if (fontSettings.isEmpty()) {
            fontSettings.put(TextAttribute.SIZE, Float.valueOf(14.0f));
            fontSettings.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        }
        try (InputStream inputStream = MaterialFonts.class.getResourceAsStream(fontPath);){
            Font font = Font.createFont(0, inputStream).deriveFont(fontSettings);
            return font;
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Font " + fontPath + " wasn't loaded");
        }
    }
}

