/*
 * Decompiled with CFR 0.152.
 */
package org.mpizexternal.components.password;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.View;
import org.mpizexternal.utils.MaterialColors;
import org.mpizexternal.utils.MaterialDrawingUtils;

public class MaterialPasswordFieldUI
extends BasicPasswordFieldUI
implements FocusListener,
PropertyChangeListener {
    private Color focusedBackground;
    private Color unfocusedBackground;
    private Color focusedSelectionBackground;
    private Color unfocusedSelectionBackground;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialPasswordFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JPasswordField passwordField = (JPasswordField)c;
        passwordField.setOpaque(false);
        passwordField.setBorder(BorderFactory.createEmptyBorder(5, 2, 10, 0));
        passwordField.setBackground(MaterialColors.LIGHT_BLUE_400);
        this.focusedBackground = passwordField.getBackground();
        this.unfocusedBackground = MaterialColors.GRAY_200;
        this.focusedSelectionBackground = MaterialColors.bleach(this.focusedBackground, 0.3f);
        this.unfocusedSelectionBackground = this.unfocusedBackground;
    }

    @Override
    protected void installListeners() {
        this.getComponent().addFocusListener(this);
        this.getComponent().addPropertyChangeListener(this);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AbstractAction selectAll = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialPasswordFieldUI.this.getComponent().selectAll();
            }
        };
        AbstractAction delete = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MaterialPasswordFieldUI.this.getComponent().getSelectedText() == null) {
                    int pos = MaterialPasswordFieldUI.this.getComponent().getCaretPosition() - 1;
                    if (pos >= 0) {
                        MaterialPasswordFieldUI.this.getComponent().select(pos, pos + 1);
                        MaterialPasswordFieldUI.this.getComponent().replaceSelection("");
                    }
                } else {
                    MaterialPasswordFieldUI.this.getComponent().replaceSelection("");
                }
            }
        };
        AbstractAction left = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialPasswordFieldUI.this.getComponent().setCaretPosition(Math.max(0, MaterialPasswordFieldUI.this.getComponent().getCaretPosition() - 1));
            }
        };
        AbstractAction right = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialPasswordFieldUI.this.getComponent().setCaretPosition(Math.min(MaterialPasswordFieldUI.this.getComponent().getText().length(), MaterialPasswordFieldUI.this.getComponent().getCaretPosition() + 1));
            }
        };
        this.getComponent().getInputMap().put(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "selectAll");
        this.getComponent().getInputMap().put(KeyStroke.getKeyStroke(8, 0), "delete");
        this.getComponent().getInputMap().put(KeyStroke.getKeyStroke(37, 0), "left");
        this.getComponent().getInputMap().put(KeyStroke.getKeyStroke(39, 0), "right");
        this.getComponent().getActionMap().put("selectAll", selectAll);
        this.getComponent().getActionMap().put("delete", delete);
        this.getComponent().getActionMap().put("left", left);
        this.getComponent().getActionMap().put("right", right);
    }

    @Override
    public void paintSafely(Graphics g) {
        JPasswordField c = (JPasswordField)this.getComponent();
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        if (this.getComponent().hasFocus()) {
            c.setBackground(this.focusedBackground);
            c.setSelectionColor(this.focusedSelectionBackground);
        } else {
            c.setBackground(this.unfocusedBackground);
            c.setSelectionColor(this.unfocusedSelectionBackground);
        }
        int x = this.getComponent().getInsets().left;
        int y = this.getComponent().getInsets().top;
        int w = this.getComponent().getWidth() - this.getComponent().getInsets().left - this.getComponent().getInsets().right;
        g.setColor(c.getBackground());
        g.fillRect(x, c.getHeight() - y, w, 2);
        super.paintSafely(g);
    }

    @Override
    public void paintBackground(Graphics g) {
        super.paintBackground(MaterialDrawingUtils.getAliasedGraphics(g));
    }

    @Override
    public void focusGained(FocusEvent e) {
        e.getComponent().setBackground(this.focusedBackground);
    }

    @Override
    public void focusLost(FocusEvent e) {
        e.getComponent().setBackground(this.unfocusedBackground);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Color newColor;
        if (pce.getPropertyName().equals("background") && !(newColor = (Color)pce.getNewValue()).equals(this.focusedBackground) && !newColor.equals(this.unfocusedBackground)) {
            this.focusedBackground = (Color)pce.getNewValue();
            this.focusedSelectionBackground = MaterialColors.bleach(this.focusedBackground, 0.3f);
        }
    }

    @Override
    public View create(Element elem) {
        return new MaterialPasswordView(elem);
    }

    private static class MaterialPasswordView
    extends PasswordView {
        private MaterialPasswordView(Element elem) {
            super(elem);
        }

        @Override
        protected int drawEchoCharacter(Graphics g, int x, int y, char c) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fm = g2.getFontMetrics();
            int r = fm.charWidth(c) - 2;
            g2.setPaint(Color.BLACK);
            g2.fillOval(x + 1, y + 5 - fm.getAscent(), r, r);
            g2.dispose();
            return x + fm.charWidth(c);
        }
    }
}

