/*
 * Decompiled with CFR 0.152.
 */
package org.mpizexternal.components.scrollbar;

import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.mpizexternal.utils.MaterialDrawingUtils;

public class MaterialScrollBarUI
extends BasicScrollBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new MaterialScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JScrollBar scrollBar = (JScrollBar)c;
        scrollBar.setFont(UIManager.getFont("ScrollBar.font"));
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbShadow");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(MaterialDrawingUtils.getAliasedGraphics(g), c);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        BasicArrowButton button = new BasicArrowButton(orientation);
        button.setOpaque(true);
        button.setBackground(UIManager.getColor("ScrollBar.arrowButtonBackground"));
        button.setBorder(UIManager.getBorder("ScrollBar.arrowButtonBorder"));
        return button;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        BasicArrowButton button = new BasicArrowButton(orientation);
        button.setOpaque(true);
        button.setBackground(UIManager.getColor("ScrollBar.arrowButtonBackground"));
        button.setBorder(UIManager.getBorder("ScrollBar.arrowButtonBorder"));
        return button;
    }
}

