/*
 * Decompiled with CFR 0.152.
 */
package org.mpizexternal.components.slider;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.mpizexternal.utils.MaterialColors;
import org.mpizexternal.utils.MaterialDrawingUtils;

public class MaterialSliderUI
extends BasicSliderUI {
    private static final int NORMAL_THUMB_RADIUS = 7;
    private static final int DRAG_THUMB_RADIUS = 14;
    private static final Dimension THUMB_SIZE = new Dimension(28, 28);

    public MaterialSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MaterialSliderUI((JSlider)c);
    }

    private static void drawCircle(Graphics g, int x, int y, int radius) {
        g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JSlider slider = (JSlider)c;
        slider.setFont(UIManager.getFont("Slider.font"));
        slider.setBackground(UIManager.getColor("Slider.background"));
        slider.setForeground(UIManager.getColor("Slider.foreground"));
        slider.setBorder(UIManager.getBorder("Slider.border"));
    }

    @Override
    public Dimension getThumbSize() {
        return THUMB_SIZE;
    }

    @Override
    public void paintThumb(Graphics g) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        int cx = this.thumbRect.x + this.thumbRect.width / 2;
        int cy = this.thumbRect.y + this.thumbRect.height / 2;
        if (this.isDragging()) {
            g.setColor(MaterialColors.bleach(this.slider.getForeground(), 0.5f));
            MaterialSliderUI.drawCircle(g, cx, cy, 14);
        }
        g.setColor(this.slider.getForeground());
        MaterialSliderUI.drawCircle(g, cx, cy, 7);
        Line loaded = this.getTrack(true);
        g.drawLine(loaded.x1, loaded.y1, loaded.x2, loaded.y2);
    }

    @Override
    public void paintTrack(Graphics g) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        g.setColor(UIManager.getColor("Slider.trackColor"));
        Line unloaded = this.getTrack(false);
        g.drawLine(unloaded.x1, unloaded.y1, unloaded.x2, unloaded.y2);
        g.setColor(this.slider.getForeground());
        Line loaded = this.getTrack(true);
        g.drawLine(loaded.x1, loaded.y1, loaded.x2, loaded.y2);
    }

    private Line getTrack(boolean loaded) {
        if (this.slider.getOrientation() == 0) {
            Line left = new Line(this.trackRect.x, this.thumbRect.y + this.thumbRect.height / 2, this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height / 2);
            Line right = new Line(this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height / 2, this.trackRect.x + this.trackRect.width, this.thumbRect.y + this.thumbRect.height / 2);
            if (loaded) {
                return this.slider.getInverted() ? right : left;
            }
            return this.slider.getInverted() ? left : right;
        }
        Line top = new Line(this.thumbRect.x + this.thumbRect.width / 2, this.trackRect.y, this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height / 2);
        Line bottom = new Line(this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height / 2, this.thumbRect.x + this.thumbRect.width / 2, this.trackRect.y + this.trackRect.height);
        if (loaded) {
            return this.slider.getInverted() ? top : bottom;
        }
        return this.slider.getInverted() ? bottom : top;
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(MaterialDrawingUtils.getAliasedGraphics(g), c);
    }

    private static class Line {
        int x1;
        int y1;
        int x2;
        int y2;

        Line(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }
    }
}

