/*
 * Decompiled with CFR 0.152.
 */
package org.mpizexternal.components.textfield;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import org.mpizexternal.utils.MaterialDrawingUtils;
import org.mpizexternal.utils.MaterialFonts;

public class MaterialTextFieldUI
extends BasicTextFieldUI
implements FocusListener,
PropertyChangeListener {
    private boolean drawLine;
    private Color activeBackground;
    private Color activeForeground;
    private Color inactiveBackground;
    private Color inactiveForeground;

    public MaterialTextFieldUI() {
        this(true);
    }

    public MaterialTextFieldUI(boolean drawLine) {
        this.drawLine = drawLine;
    }

    public static ComponentUI createUI(JComponent c) {
        return new MaterialTextFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.installMyDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this.getComponent().setBorder(null);
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this);
        this.getComponent().addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this);
        super.uninstallListeners();
    }

    private void installMyDefaults() {
        this.activeBackground = UIManager.getColor("TextField.selectionBackground");
        this.activeForeground = UIManager.getColor("TextField.selectionForeground");
        this.inactiveBackground = UIManager.getColor("TextField.inactiveBackground");
        this.inactiveForeground = UIManager.getColor("TextField.inactiveForeground");
        this.getComponent().setFont(MaterialFonts.REGULAR);
        this.getComponent().setSelectionColor(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeBackground : this.inactiveBackground);
        this.getComponent().setSelectedTextColor(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeForeground : this.inactiveForeground);
        this.getComponent().setForeground(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeForeground : this.inactiveForeground);
        this.getComponent().setBorder(BorderFactory.createEmptyBorder(3, 5, 2, 5));
    }

    @Override
    protected void paintBackground(Graphics g) {
        super.paintBackground(MaterialDrawingUtils.getAliasedGraphics(g));
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.changeColorOnFocus(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.changeColorOnFocus(false);
    }

    private void changeColorOnFocus(boolean hasFocus) {
        JTextField c = (JTextField)this.getComponent();
        if (hasFocus && this.activeBackground != null && this.activeForeground != null) {
            c.setSelectionColor(this.activeBackground);
            c.setForeground(this.activeForeground);
            c.setSelectedTextColor(this.activeForeground);
        }
        if (!hasFocus && this.inactiveBackground != null && this.inactiveForeground != null) {
            c.setSelectionColor(this.inactiveBackground);
            c.setForeground(this.inactiveForeground);
            c.setSelectedTextColor(this.inactiveForeground);
        }
        c.paint(c.getGraphics());
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AbstractAction selectAll = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MaterialTextFieldUI.this.getComponent() != null) {
                    MaterialTextFieldUI.this.getComponent().selectAll();
                }
            }
        };
        AbstractAction delete = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MaterialTextFieldUI.this.getComponent().getSelectedText() == null) {
                    int pos = MaterialTextFieldUI.this.getComponent().getCaretPosition() - 1;
                    if (pos >= 0) {
                        MaterialTextFieldUI.this.getComponent().select(pos, pos + 1);
                        MaterialTextFieldUI.this.getComponent().replaceSelection("");
                    }
                } else {
                    MaterialTextFieldUI.this.getComponent().replaceSelection("");
                }
            }
        };
        AbstractAction left = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MaterialTextFieldUI.this.getComponent() != null) {
                    MaterialTextFieldUI.this.getComponent().setCaretPosition(Math.max(0, MaterialTextFieldUI.this.getComponent().getCaretPosition() - 1));
                }
            }
        };
        AbstractAction right = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MaterialTextFieldUI.this.getComponent() != null) {
                    MaterialTextFieldUI.this.getComponent().setCaretPosition(Math.min(MaterialTextFieldUI.this.getComponent().getText().length(), MaterialTextFieldUI.this.getComponent().getCaretPosition() + 1));
                }
            }
        };
        AbstractAction enter = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MaterialTextFieldUI.this.getComponent() != null) {
                    ((JTextField)MaterialTextFieldUI.this.getComponent()).postActionEvent();
                }
            }
        };
        this.getComponent().getInputMap().put(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "selectAll");
        this.getComponent().getInputMap().put(KeyStroke.getKeyStroke(8, 0), "delete");
        this.getComponent().getInputMap().put(KeyStroke.getKeyStroke(37, 0), "left");
        this.getComponent().getInputMap().put(KeyStroke.getKeyStroke(39, 0), "right");
        this.getComponent().getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.getComponent().getActionMap().put("selectAll", selectAll);
        this.getComponent().getActionMap().put("delete", delete);
        this.getComponent().getActionMap().put("left", left);
        this.getComponent().getActionMap().put("right", right);
        this.getComponent().getActionMap().put("enter", enter);
    }

    @Override
    public void paintSafely(Graphics g) {
        JTextField c = (JTextField)this.getComponent();
        super.paintSafely(g);
        if (this.drawLine) {
            int x = c.getInsets().left;
            int y = c.getInsets().top;
            int w = c.getWidth() - c.getInsets().left - c.getInsets().right;
            g.setColor(c.getSelectionColor());
            g.fillRect(x, c.getHeight() - y - 1, w, 2);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Color newColor;
        super.propertyChange(pce);
        if (pce.getPropertyName().equals("selectionColor") && !(newColor = (Color)pce.getNewValue()).equals(this.activeBackground) && !newColor.equals(this.inactiveBackground)) {
            this.activeBackground = newColor;
            this.getComponent().repaint();
        }
        if (pce.getPropertyName().equals("selectedTextColor") && !(newColor = (Color)pce.getNewValue()).equals(this.activeForeground) && !newColor.equals(this.inactiveForeground)) {
            this.activeForeground = newColor;
            this.getComponent().repaint();
        }
        if (pce.getPropertyName().equals("background")) {
            this.getComponent().repaint();
        }
    }
}

