/*
 * Decompiled with CFR 0.152.
 */
package org.mpiztools.clinter.thread;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.mpiztools.clinter.cmd.Command;

public class CommandTask
implements Callable<String> {
    private final Command cmd;
    private Process proc;
    private boolean cancelled;

    public CommandTask(Command cmd) throws IOException {
        this.cmd = cmd;
        this.proc = Runtime.getRuntime().exec(cmd.toString());
        this.cancelled = false;
    }

    String getCommandOutput() throws IOException {
        int read;
        InputStream scanStream;
        StringBuilder sbOutput = new StringBuilder();
        InputStream inputStream = this.proc.getInputStream();
        InputStream inputStream2 = scanStream = inputStream.available() > 0 ? inputStream : this.proc.getErrorStream();
        while ((read = scanStream.read()) != -1) {
            sbOutput.append((char)read);
        }
        return sbOutput.toString();
    }

    public Process getProc() {
        return this.proc;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public String call() throws Exception {
        this.proc.waitFor();
        return this.getCommandOutput();
    }
}

