/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.common.retry.policies;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.retry.RetryPolicy;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.modules.common.retry.policies.RetryWork;
import org.mule.retry.DefaultRetryContext;

public class AdaptiveRetryPolicyTemplateWrapper
implements RetryPolicyTemplate,
MuleContextAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private RetryPolicyTemplate delegate;
    private MuleContext muleContext;
    private Map metaInfo;
    private int initialAttemptTimeout = 5000;

    public RetryPolicy createRetryInstance() {
        return this.delegate.createRetryInstance();
    }

    public RetryContext execute(RetryCallback callback, WorkManager workManager) throws Exception {
        RetryWork retryWork = new RetryWork(this.muleContext, workManager, this.delegate, callback);
        if (this.muleContext.isStarted()) {
            return this.doSynchronousReconnection(callback, retryWork);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing retry callback asynchronously: " + callback));
        }
        workManager.scheduleWork((Work)retryWork);
        return this.trySynchronousConnection(callback, retryWork);
    }

    private RetryContext doSynchronousReconnection(RetryCallback callback, RetryWork retryWork) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing retry callback synchronously: " + callback));
        }
        retryWork.run();
        return retryWork.getRetryContextResult();
    }

    private RetryContext trySynchronousConnection(RetryCallback callback, RetryWork retryWork) throws InterruptedException {
        if (retryWork.await(this.initialAttemptTimeout, TimeUnit.MILLISECONDS)) {
            RetryContext retryContext = retryWork.getRetryContextResult();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Successful synchronous execution of callback: " + retryContext.getDescription()));
            }
            return retryContext;
        }
        return new DefaultRetryContext(callback.getWorkDescription());
    }

    public RetryNotifier getNotifier() {
        return this.delegate.getNotifier();
    }

    public void setDelegate(RetryPolicyTemplate delegate) {
        this.delegate = delegate;
    }

    public void setInitialAttemptTimeout(int initialAttemptTimeout) {
        this.initialAttemptTimeout = initialAttemptTimeout;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setNotifier(RetryNotifier retryNotifier) {
        this.delegate.setNotifier(retryNotifier);
    }

    public Map getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(Map metaInfo) {
        this.metaInfo = metaInfo;
    }
}

