/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.mule.transport.rabbitmq;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.util.MapUtils;

public class EndpointUtils {
    public static String getRealm(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"realm", (String)"/data");
    }

    public static String getQueue(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"queue", null);
    }

    public static String getExchange(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"exchange", null);
    }

    public static String getExchangeType(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"exchange-type", (String)"direct");
    }

    public static String getRoutingKey(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"routing-key", (String)"");
    }

    public static boolean getDurable(ImmutableEndpoint e) {
        return MapUtils.getBooleanValue((Map)e.getProperties(), (Object)"durable", (boolean)false);
    }

    public static String declareExchange(Channel channel, ImmutableEndpoint e) throws IOException {
        String exchange = EndpointUtils.getExchange(e);
        if (exchange != null) {
            channel.exchangeDeclare(exchange, EndpointUtils.getExchangeType(e), EndpointUtils.getDurable(e));
        }
        return exchange;
    }
}

