/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.mule.transport.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.trpr.mule.transport.rabbitmq.EndpointUtils;
import org.trpr.mule.transport.rabbitmq.RabbitReplyToHandler;

public class RabbitConnector
extends AbstractConnector {
    public static final String AMQP = "amqp";
    public static final String RABBIT_MQ_ENVELOPE_PROPERTY = "rabbitmq.envelope";
    public static final String RABBIT_MQ_CONSUMER_TAG_PROPERTY = "rabbitmq.consumerTag";
    private static final int CLOSE_TIMEOUT = 1000;
    private static final int DEFAULT_DURABLE_MSG_COMMIT_COUNT = 1;
    private static final int DEFAULT_PREFETCH_COUNT = -1;
    private Connection connection;
    private String username;
    private String password;
    private String virtualHost;
    private String host;
    private int durableMessageCommitCount = 1;
    private int prefetchCount = -1;
    private int port = 5672;
    private int requestHeartBeat;
    private RabbitReplyToHandler repyToHandler;

    public String getProtocol() {
        return AMQP;
    }

    public synchronized ChannelHolder createChannel(ImmutableEndpoint endpoint) throws IOException, InitialisationException {
        Channel channel = this.connection.createChannel();
        if (channel == null) {
            throw new InitialisationException(CoreMessages.failedToCreate((String)Channel.class.getName()), null);
        }
        if (this.getPrefetchCount() != -1) {
            channel.basicQos(this.getPrefetchCount());
        }
        if (EndpointUtils.getDurable(endpoint) && endpoint instanceof OutboundEndpoint) {
            channel.txSelect();
        }
        return new ChannelHolder(channel);
    }

    protected Object getReceiverKey(Service service, InboundEndpoint endpoint) {
        return service.getName() + "~" + endpoint.getEndpointURI().getAddress();
    }

    protected void doInitialise() throws InitialisationException {
        this.repyToHandler = new RabbitReplyToHandler();
    }

    protected synchronized void doDispose() {
        this.closeConnection();
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    protected void doConnect() throws Exception {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(this.username);
        factory.setPassword(this.password);
        factory.setVirtualHost(this.virtualHost);
        factory.setRequestedHeartbeat(this.requestHeartBeat);
        factory.setHost(this.host);
        factory.setPort(this.port);
        this.connection = factory.newConnection();
    }

    protected void signalConnectionLost() {
        try {
            if (this.connection != null) {
                this.connection.close(1000);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)("Error closing existing Connection instance. Continuing by marking Connection instance as null. Error is : " + e.getMessage()));
        }
        this.connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptReconnect() throws Exception {
        RabbitConnector rabbitConnector = this;
        synchronized (rabbitConnector) {
            if (this.connection == null) {
                this.doConnect();
            }
        }
    }

    protected void doDisconnect() throws Exception {
    }

    protected Object getReceiverKey(Component component, InboundEndpoint endpoint) {
        return endpoint.getEndpointURI().toString();
    }

    private synchronized void closeConnection() {
        try {
            this.connection.close(200, "Goodbye");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = null;
    }

    public ReplyToHandler getReplyToHandler() {
        return this.repyToHandler;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public int getDurableMessageCommitCount() {
        return this.durableMessageCommitCount;
    }

    public void setDurableMessageCommitCount(int durableMessageCommitCount) {
        this.durableMessageCommitCount = durableMessageCommitCount;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public int getRequestHeartBeat() {
        return this.requestHeartBeat;
    }

    public void setRequestHeartBeat(int requestHeartBeat) {
        this.requestHeartBeat = requestHeartBeat;
    }

    public class ChannelHolder {
        private Channel channel;

        public ChannelHolder(Channel channel) {
            this.channel = channel;
        }

        public Channel getChannel() {
            return this.channel;
        }
    }
}

