/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.mule.transport.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.RpcClient;
import java.io.IOException;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageRequester;
import org.trpr.mule.transport.rabbitmq.EndpointUtils;
import org.trpr.mule.transport.rabbitmq.RabbitConnector;
import org.trpr.mule.transport.rabbitmq.i18n.RabbitMessages;

public class RabbitMessageRequester
extends AbstractMessageRequester {
    private RpcClient rpcClient;
    private Channel channel;

    public RabbitMessageRequester(InboundEndpoint endpoint) throws CreateException {
        super(endpoint);
        RabbitConnector conn = (RabbitConnector)this.connector;
        try {
            RabbitConnector.ChannelHolder ch = conn.createChannel((ImmutableEndpoint)endpoint);
            this.channel = ch.getChannel();
            this.logger.debug((Object)("RabbitMessageRequester opened channel: " + this.channel));
            String exchange = EndpointUtils.declareExchange(this.channel, (ImmutableEndpoint)endpoint);
            String routingKey = EndpointUtils.getRoutingKey((ImmutableEndpoint)endpoint);
            String queue = EndpointUtils.getQueue((ImmutableEndpoint)endpoint);
            if (queue != null) {
                exchange = "";
                routingKey = queue;
            }
            this.logger.debug((Object)("RpcClient initialised on exchange: " + exchange + ", routing key: " + routingKey));
            this.rpcClient = new RpcClient(this.channel, exchange, routingKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CreateException((Throwable)e, null);
        }
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        try {
            String queue = EndpointUtils.getQueue(this.endpoint);
            if (queue == null) {
                throw new IllegalArgumentException(RabbitMessages.noQueueDefined(this.endpoint).getMessage());
            }
            long time = System.currentTimeMillis() + timeout;
            for (long count = System.currentTimeMillis(); count < time; count += 50L) {
                GetResponse response = this.rpcClient.getChannel().basicGet(queue, false);
                if (response == null) {
                    Thread.sleep(50L);
                    continue;
                }
                AMQP.BasicProperties props = response.getProps();
                byte[] body = response.getBody();
                MessageAdapter adapter = this.connector.getMessageAdapter((Object)new Object[]{body, props});
                return new DefaultMuleMessage((Object)adapter);
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    protected void doDispose() {
        try {
            if (this.rpcClient != null) {
                this.rpcClient.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

