/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.mule.transport.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.HashMap;
import javax.resource.spi.work.Work;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.util.StringUtils;
import org.trpr.mule.transport.rabbitmq.EndpointUtils;
import org.trpr.mule.transport.rabbitmq.RabbitConnector;

public class RabbitMessageReceiver
extends AbstractMessageReceiver
implements Consumer,
Runnable {
    private static final int IDLE = 0;
    private static final int TRY_RECONNECT = 1;
    private static final int EXIT = 2;
    private static final long RECONNECT_SLEEP_INTERVAL = 5000L;
    private volatile int reconnectState = 0;
    private Channel channel;
    private String queue;
    private String exchange;
    private String routingKey;
    private boolean startOnConnect = false;

    public RabbitMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
    }

    protected void doConnect() throws Exception {
        String dlQueue = null;
        String dlExchange = null;
        RabbitConnector conn = (RabbitConnector)this.connector;
        RabbitConnector.ChannelHolder ch = conn.createChannel(this.endpoint);
        this.channel = ch.getChannel();
        this.logger.debug((Object)("Receiver opened channel: " + this.channel));
        this.queue = EndpointUtils.getQueue(this.endpoint);
        this.routingKey = EndpointUtils.getRoutingKey(this.endpoint);
        if (EndpointUtils.getExchangeType(this.endpoint).equals("direct") && StringUtils.isEmpty((String)this.routingKey)) {
            this.routingKey = this.queue;
        }
        if (this.queue == null) {
            this.logger.debug((Object)"Declaring private queue");
            this.queue = this.channel.queueDeclare().getQueue();
            this.logger.debug((Object)("Private queue name: " + this.queue));
        } else {
            this.logger.debug((Object)("Declaring well-known queue: " + this.queue));
            if (EndpointUtils.isDeadLetterEnabled(this.endpoint)) {
                dlQueue = this.queue + ".dead";
                dlExchange = EndpointUtils.getExchange(this.endpoint) + ".dead";
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("x-dead-letter-exchange", dlExchange);
                args.put("x-dead-letter-routing-key", this.routingKey);
                this.channel.queueDeclare(dlQueue, EndpointUtils.isDurable(this.endpoint), false, false, null);
                this.channel.queueDeclare(this.queue, EndpointUtils.isDurable(this.endpoint), false, false, args);
            } else {
                this.channel.queueDeclare(this.queue, EndpointUtils.isDurable(this.endpoint), false, false, null);
            }
        }
        if (this.startOnConnect) {
            this.doStart();
        }
        this.exchange = EndpointUtils.declareExchange(this.channel, this.endpoint);
        this.logger.debug((Object)("Using exchange: " + this.exchange + ", routing key: " + this.routingKey));
        this.channel.queueBind(this.queue, this.exchange, this.routingKey);
        if (EndpointUtils.isDeadLetterEnabled(this.endpoint) && dlQueue != null && dlExchange != null) {
            this.logger.debug((Object)("Using dl exchange: " + dlExchange + ", routing key: " + this.routingKey));
            this.channel.queueBind(dlQueue, dlExchange, this.routingKey);
        }
        if (this.reconnectState != 1) {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }
    }

    protected void doDisconnect() throws Exception {
        this.closeChannelQuietly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        this.reconnectState = 2;
        RabbitMessageReceiver rabbitMessageReceiver = this;
        synchronized (rabbitMessageReceiver) {
            this.notifyAll();
        }
    }

    protected void doStart() throws MuleException {
        try {
            if (this.channel == null) {
                this.startOnConnect = true;
            } else {
                this.startOnConnect = false;
                this.channel.basicConsume(this.queue, (Consumer)this);
            }
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    protected void doStop() throws MuleException {
        this.closeChannelQuietly();
    }

    public void handleCancelOk(String consumerTag) {
        this.logger.debug((Object)("Consumer tag cancelled: " + consumerTag));
    }

    public void handleConsumeOk(String consumerTag) {
        this.logger.debug((Object)("Consuming from tag: " + consumerTag));
    }

    public void handleCancel(String consumerTag) throws IOException {
    }

    public void handleRecoverOk(String consumerTag) {
    }

    public void handleDelivery(String consumerTag, Envelope env, AMQP.BasicProperties props, byte[] body) throws IOException {
        try {
            this.getWorkManager().scheduleWork((Work)new AMQPWorker(this, consumerTag, env, props, body));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        this.logger.debug((Object)("Shutdown signal received: " + sig));
        this.stop();
        ((RabbitConnector)this.connector).signalConnectionLost();
        this.reconnectState = this.connector.isStarted() ? 1 : 2;
        RabbitMessageReceiver rabbitMessageReceiver = this;
        synchronized (rabbitMessageReceiver) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: while (true) {
            switch (this.reconnectState) {
                case 0: {
                    RabbitMessageReceiver rabbitMessageReceiver = this;
                    synchronized (rabbitMessageReceiver) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        break;
                    }
                }
                case 1: {
                    RabbitMessageReceiver rabbitMessageReceiver = this;
                    synchronized (rabbitMessageReceiver) {
                        try {
                            this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        ((RabbitConnector)this.connector).attemptReconnect();
                        try {
                            this.startOnConnect = true;
                            this.doConnect();
                            this.logger.info((Object)"Reconnect with Rabbit instance successful");
                        }
                        catch (InitialisationException ie) {
                            this.logger.error((Object)("doConnect method failed on RabbitMessageReceiver during attempt to reconnect : " + ie.getMessage()), (Throwable)ie);
                            this.handleException((Exception)((Object)ie));
                        }
                        this.reconnectState = 0;
                    }
                    catch (Exception e) {
                        this.logger.info((Object)"Reconnect failed to Rabbit instance, will try again in : 5000 ms");
                    }
                    continue block19;
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private void closeChannelQuietly() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                this.logger.info((Object)("Error closing channel. Ignoring it. Exception is : " + e.getMessage()));
            }
        }
    }

    protected class AMQPWorker
    implements Work {
        private String consumerTag;
        private Envelope env;
        private AMQP.BasicProperties props;
        private byte[] body;

        public AMQPWorker(AbstractMessageReceiver receiver, String consumerTag, Envelope env, AMQP.BasicProperties props, byte[] body) {
            this.consumerTag = consumerTag;
            this.env = env;
            this.props = props;
            this.body = body;
        }

        public void run() {
            boolean synchronous = false;
            if (this.props.getReplyTo() != null && !this.props.getReplyTo().equals("") || RabbitMessageReceiver.this.endpoint.isSynchronous()) {
                synchronous = true;
            }
            try {
                MessageAdapter adapter = RabbitMessageReceiver.this.connector.getMessageAdapter((Object)new Object[]{this.body, this.props});
                adapter.setProperty("rabbitmq.envelope", (Object)this.env);
                adapter.setProperty("rabbitmq.consumerTag", (Object)this.consumerTag);
                MuleMessage returnMessage = RabbitMessageReceiver.this.routeMessage((MuleMessage)new DefaultMuleMessage((Object)adapter), synchronous);
                if (synchronous && this.props.getReplyTo() != null && !this.props.getReplyTo().equals("")) {
                    RabbitMessageReceiver.this.channel.basicPublish("", this.props.getReplyTo(), new AMQP.BasicProperties(null, null, null, null, null, this.props.getCorrelationId(), null, null, null, null, null, null, null, null), returnMessage.getPayloadAsBytes());
                }
                if (synchronous && returnMessage.getExceptionPayload() != null) {
                    if (this.env.isRedeliver()) {
                        RabbitMessageReceiver.this.channel.basicReject(this.env.getDeliveryTag(), false);
                    } else {
                        RabbitMessageReceiver.this.channel.basicReject(this.env.getDeliveryTag(), EndpointUtils.isMessageRequeued(RabbitMessageReceiver.this.endpoint));
                    }
                } else {
                    RabbitMessageReceiver.this.channel.basicAck(this.env.getDeliveryTag(), false);
                }
            }
            catch (Exception e) {
                RabbitMessageReceiver.this.handleException(e);
            }
        }

        public void release() {
        }
    }
}

