/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.mule.transport.rabbitmq;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.util.MapUtils;

public class EndpointUtils {
    public static final String DEAD_SUFFIX = ".dead";
    public static final String RMQ_DL_ARGUMENT = "x-dead-letter-exchange";
    public static final String RMQ_DL_RT_KEY = "x-dead-letter-routing-key";

    public static String getRealm(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"realm", (String)"/data");
    }

    public static String getQueue(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"queue", null);
    }

    public static String getExchange(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"exchange", null);
    }

    public static String getExchangeType(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"exchange-type", (String)"direct");
    }

    public static String getRoutingKey(ImmutableEndpoint e) {
        return MapUtils.getString((Map)e.getProperties(), (Object)"routing-key", (String)"");
    }

    public static boolean isDurable(ImmutableEndpoint e) {
        return MapUtils.getBooleanValue((Map)e.getProperties(), (Object)"durable", (boolean)false);
    }

    public static boolean isDeadLetterEnabled(ImmutableEndpoint e) {
        return MapUtils.getBooleanValue((Map)e.getProperties(), (Object)"dead-lettered", (boolean)false);
    }

    public static boolean isMessageRequeued(ImmutableEndpoint e) {
        return MapUtils.getBooleanValue((Map)e.getProperties(), (Object)"message-requeued", (boolean)false);
    }

    public static boolean isUsePredeclaredQueue(ImmutableEndpoint e) {
        return MapUtils.getBooleanValue((Map)e.getProperties(), (Object)"isUsePredeclaredQueue", (boolean)false);
    }

    public static String declareExchange(Channel channel, ImmutableEndpoint e) throws IOException {
        String exchange = EndpointUtils.getExchange(e);
        if (exchange != null) {
            channel.exchangeDeclare(exchange, EndpointUtils.getExchangeType(e), EndpointUtils.isDurable(e));
            if (EndpointUtils.isDeadLetterEnabled(e)) {
                channel.exchangeDeclare(exchange + DEAD_SUFFIX, EndpointUtils.getExchangeType(e), EndpointUtils.isDurable(e));
            }
        }
        return exchange;
    }
}

