/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.mule.transport.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.RpcClient;
import java.io.IOException;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.AbstractMessageDispatcher;
import org.trpr.mule.transport.rabbitmq.EndpointUtils;
import org.trpr.mule.transport.rabbitmq.RabbitConnector;

public class RabbitDispatcher
extends AbstractMessageDispatcher {
    private RpcClient rpcClient;
    private Channel channel;
    private long dispatchedMessageCount;

    public RabbitDispatcher(OutboundEndpoint endpoint) throws InitialisationException {
        super(endpoint);
    }

    protected void doConnect() throws Exception {
        RabbitConnector conn = (RabbitConnector)this.connector;
        try {
            if (this.channel != null && this.channel.getConnection() != conn.getConnection()) {
                this.rpcClient = null;
            }
            if (this.rpcClient == null) {
                RabbitConnector.ChannelHolder ch = conn.createChannel(this.endpoint);
                this.channel = ch.getChannel();
                this.logger.debug((Object)("Dispatcher opened channel: " + this.channel));
                String exchange = EndpointUtils.declareExchange(this.channel, this.endpoint);
                String routingKey = EndpointUtils.getRoutingKey(this.endpoint);
                String queue = EndpointUtils.getQueue(this.endpoint);
                if (queue != null) {
                    exchange = "";
                    routingKey = queue;
                }
                this.logger.debug((Object)("RpcClient initialised on exchange: " + exchange + ", routing key: " + routingKey));
                this.rpcClient = new RpcClient(this.channel, exchange, routingKey);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InitialisationException((Throwable)e, null);
        }
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(MuleEvent event) throws Exception {
        MuleMessage msg = event.getMessage();
        AMQP.BasicProperties msgProps = EndpointUtils.isDurable(this.endpoint) ? MessageProperties.PERSISTENT_BASIC : MessageProperties.BASIC;
        this.rpcClient.publish(msgProps, msg.getPayloadAsBytes());
        ++this.dispatchedMessageCount;
        if (EndpointUtils.isDurable(this.endpoint) && this.dispatchedMessageCount % (long)((RabbitConnector)this.connector).getDurableMessageCommitCount() == 0L) {
            Channel channel = this.channel;
            synchronized (channel) {
                this.channel.txCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        try {
            if (EndpointUtils.isDurable(this.endpoint)) {
                Channel channel = this.channel;
                synchronized (channel) {
                    this.channel.txCommit();
                }
            }
            if (this.rpcClient != null) {
                this.rpcClient.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        MuleMessage msg = event.getMessage();
        if (EndpointUtils.isDurable(this.endpoint)) {
            throw new Exception("Durable end-points not supported for synchronous calls. Configuration mis-match.");
        }
        byte[] response = this.rpcClient.primitiveCall(msg.getPayloadAsBytes());
        return new DefaultMuleMessage((Object)response);
    }
}

