/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.mule.transport.rabbitmq;

import com.rabbitmq.client.AMQP;
import java.util.Map;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMessageAdapter;

public class RabbitMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = 1L;
    private byte[] payload;
    private AMQP.BasicProperties props;

    public RabbitMessageAdapter(Object message) throws MessageTypeNotSupportedException {
        if (message instanceof Object[]) {
            this.payload = (byte[])((Object[])message)[0];
            if (((Object[])message).length > 1) {
                this.props = (AMQP.BasicProperties)((Object[])message)[1];
                if (this.props.getHeaders() != null) {
                    for (Map.Entry e : this.props.getHeaders().entrySet()) {
                        String key = (String)e.getKey();
                        Object value = e.getValue();
                        if (value == null) continue;
                        this.setProperty(key, value);
                    }
                }
            }
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
    }

    protected RabbitMessageAdapter(RabbitMessageAdapter template) {
        super((MessageAdapter)template);
        this.payload = template.payload;
        this.props = template.props;
    }

    public Object getPayload() {
        return this.payload;
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.payload;
    }

    public String getPayloadAsString(String s) throws Exception {
        return new String(this.payload, s);
    }

    public String getUniqueId() {
        return this.props.getMessageId() == null ? this.id : this.props.getMessageId();
    }

    public Object getReplyTo() {
        return this.props.getReplyTo();
    }

    public String getEncoding() {
        return this.props.getContentEncoding() == null ? super.getEncoding() : this.props.getContentEncoding();
    }

    public String getCorrelationId() {
        return this.props.getCorrelationId();
    }

    public ThreadSafeAccess newThreadCopy() {
        return new RabbitMessageAdapter(this);
    }
}

