/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.api.jaxrs.mapper.ApiError;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.settings.EmailSettings;
import org.mycontroller.standalone.settings.LocationSettings;
import org.mycontroller.standalone.settings.MyControllerSettings;
import org.mycontroller.standalone.settings.MySensorsSettings;
import org.mycontroller.standalone.settings.SettingsUtils;
import org.mycontroller.standalone.settings.SmsSettings;
import org.mycontroller.standalone.settings.UnitsSettings;
import org.mycontroller.standalone.sms.SMSUtils;
import org.mycontroller.standalone.timer.TimerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rest/settings")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"user"})
public class SettingsHandler {
    private static final Logger _logger = LoggerFactory.getLogger((String)SettingsHandler.class.getName());

    @GET
    @Path(value="/location")
    public Response getLocation() {
        return RestUtils.getResponse(Response.Status.OK, ObjectFactory.getAppProperties().getLocationSettings());
    }

    @POST
    @Path(value="/location")
    public Response saveLocation(LocationSettings locationSettings) {
        locationSettings.save();
        SettingsUtils.updateAllSettings();
        try {
            TimerUtils.updateSunriseSunset();
        }
        catch (Exception ex) {
            _logger.error("Exception,", (Throwable)ex);
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError(ex.getMessage()));
        }
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/controller")
    public Response getController() {
        return RestUtils.getResponse(Response.Status.OK, ObjectFactory.getAppProperties().getControllerSettings());
    }

    @POST
    @Path(value="/controller")
    public Response saveController(MyControllerSettings myControllerSettings) {
        myControllerSettings.save();
        SettingsUtils.updateAllSettings();
        try {
            TimerUtils.updateSunriseSunset();
        }
        catch (Exception ex) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("Error: " + ex.getMessage()));
        }
        return RestUtils.getResponse(Response.Status.OK);
    }

    @PUT
    @Path(value="/updateLanguage")
    public Response updateLanguage(String language) {
        if (language != null && AppProperties.MC_LANGUAGE.fromString(language) != null) {
            MyControllerSettings.builder().language(language).build().save();
            SettingsUtils.updateAllSettings();
            return RestUtils.getResponse(Response.Status.OK);
        }
        return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("Unknown language: " + language));
    }

    @GET
    @Path(value="/email")
    public Response getEmail() {
        return RestUtils.getResponse(Response.Status.OK, ObjectFactory.getAppProperties().getEmailSettings());
    }

    @POST
    @Path(value="/email")
    public Response saveEmail(EmailSettings emailSettings) {
        emailSettings.save();
        SettingsUtils.updateAllSettings();
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/sms")
    public Response getSms() {
        return RestUtils.getResponse(Response.Status.OK, ObjectFactory.getAppProperties().getSmsSettings());
    }

    @POST
    @Path(value="/sms")
    public Response saveSms(SmsSettings smsSettings) {
        smsSettings.save();
        SettingsUtils.updateAllSettings();
        SMSUtils.clearClients();
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/mySensors")
    public Response getMySensors() {
        return RestUtils.getResponse(Response.Status.OK, ObjectFactory.getAppProperties().getMySensorsSettings());
    }

    @POST
    @Path(value="/mySensors")
    public Response saveMySensors(MySensorsSettings mySensorsSettings) {
        mySensorsSettings.save();
        SettingsUtils.updateAllSettings();
        return RestUtils.getResponse(Response.Status.OK);
    }

    @GET
    @Path(value="/units")
    public Response getUnits() {
        return RestUtils.getResponse(Response.Status.OK, ObjectFactory.getAppProperties().getUnitsSettings());
    }

    @POST
    @Path(value="/units")
    public Response saveUnits(UnitsSettings unitsSettings) {
        unitsSettings.save();
        SettingsUtils.updateAllSettings();
        return RestUtils.getResponse(Response.Status.OK);
    }
}

