/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs.exception.mappers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.mycontroller.standalone.db.SensorUtils;
import org.mycontroller.standalone.db.tables.SensorVariable;

@JsonAutoDetect
public class VariableStatusModel {
    private Integer id;
    private String type;
    private String metricType;
    private String unit;
    private Object value;
    private String friendlyValue;
    private Long timestamp;

    @JsonCreator
    private VariableStatusModel() {
    }

    public VariableStatusModel(SensorVariable sensorVariable) {
        this.id = sensorVariable.getId();
        if (sensorVariable.getVariableType() != null) {
            this.type = sensorVariable.getVariableType().getText();
        }
        if (sensorVariable.getMetricType() != null) {
            this.metricType = sensorVariable.getMetricType().getText();
        }
        this.unit = sensorVariable.getUnit();
        this.value = sensorVariable.getValue();
        this.friendlyValue = SensorUtils.getValue(sensorVariable);
        this.timestamp = sensorVariable.getTimestamp();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getFriendlyValue() {
        return this.friendlyValue;
    }

    public void setFriendlyValue(String friendlyValue) {
        this.friendlyValue = friendlyValue;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }
}

