/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.TimerDao;
import org.mycontroller.standalone.db.tables.Timer;
import org.mycontroller.standalone.scheduler.SchedulerUtils;

public class TimerDaoImpl
extends BaseAbstractDaoImpl<Timer, Integer>
implements TimerDao {
    public TimerDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, Timer.class);
    }

    @Override
    public void create(Timer timer) {
        try {
            int count = this.getDao().create((Object)timer);
            _logger.debug("Created Timer:[{}], Create count:{}", (Object)timer, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add Timer:[{}]", (Object)timer, (Object)ex);
        }
    }

    @Override
    public void createOrUpdate(Timer timer) {
        try {
            Dao.CreateOrUpdateStatus status = this.getDao().createOrUpdate((Object)timer);
            SchedulerUtils.reloadTimerJob(timer);
            _logger.debug("CreateOrUpdate Timer:[{}],Create:{},Update:{},Lines Changed:{}", new Object[]{timer, status.isCreated(), status.isUpdated(), status.getNumLinesChanged()});
        }
        catch (SQLException ex) {
            _logger.error("unable to CreateOrUpdate Timer:[{}]", (Object)timer, (Object)ex);
        }
    }

    @Override
    public void delete(Timer timer) {
        try {
            int count = this.getDao().delete((Object)timer);
            SchedulerUtils.unloadTimerJob(timer);
            _logger.debug("Timer:[{}] deleted, Delete count:{}", (Object)timer, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete timer:[{}]", (Object)timer, (Object)ex);
        }
    }

    @Override
    public void delete(int id) {
        this.delete(this.get(id));
    }

    @Override
    public void update(Timer timer) {
        try {
            int count = this.getDao().update((Object)timer);
            _logger.debug("Updated Timer:[{}], Update count:{}", (Object)timer, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to update timer:[{}]", (Object)timer, (Object)ex);
        }
    }

    @Override
    public List<Timer> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all Nodes", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<Timer> getAll(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        QueryBuilder queryBuilder = this.getDao().queryBuilder();
        Where where = queryBuilder.where();
        try {
            where.eq("resourceType", (Object)resourceType);
            if (resourceId != null) {
                where.and().eq("resourceId", (Object)resourceId);
            }
            return where.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to query timers with Resource:[Type:{}, KEY_ID:{}]", new Object[]{resourceType.getText(), resourceId, ex});
            return null;
        }
    }

    @Override
    public List<Timer> getAll(AppProperties.RESOURCE_TYPE resourceType) {
        return this.getAll(resourceType, null);
    }

    @Override
    public void delete(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("resourceType", (Object)resourceType).and().eq("resourceId", (Object)resourceId);
            int count = deleteBuilder.delete();
            _logger.debug("deleted timers with Resource:[Type:{}, KEY_ID:{}], Deletion Count:{}", new Object[]{resourceType.getText(), resourceId, count});
        }
        catch (SQLException ex) {
            _logger.error("unable to delete timers with Resource:[Type:{}, KEY_ID:{}]", new Object[]{resourceType.getText(), resourceId, ex});
        }
    }

    @Override
    public List<Timer> getAllEnabled() {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("enabled", (Object)true);
            List timers = this.getDao().query(queryBuilder.prepare());
            return timers;
        }
        catch (SQLException ex) {
            _logger.error("unable to get all enabled timers", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Timer get(int id) {
        try {
            return (Timer)this.getDao().queryForId((Object)id);
        }
        catch (SQLException ex) {
            _logger.error("unable to get Timer[id:{}]", (Object)id, (Object)ex);
            return null;
        }
    }

    @Override
    public long countOf(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("resourceType", (Object)resourceType).and().eq("resourceId", (Object)resourceId);
            return queryBuilder.countOf();
        }
        catch (SQLException ex) {
            _logger.error("unable to get Timers count for resource[Type:{}, Id:{}]", new Object[]{resourceType, resourceId, ex});
            return 0L;
        }
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }
}

