/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.serialport;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.gateway.GatewaySerial;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.gateway.serialport.SerialDataListenerjSerialComm;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPortjSerialCommImpl
implements IGateway {
    private static final Logger _logger = LoggerFactory.getLogger((String)SerialPortjSerialCommImpl.class.getName());
    private SerialPort serialPort;
    private GatewaySerial gateway = null;

    public SerialPortjSerialCommImpl(GatewaySerial gateway) {
        this.gateway = gateway;
        this.initialize();
    }

    @Override
    public synchronized void write(RawMessage rawMessage) {
        try {
            this.serialPort.writeBytes(rawMessage.getGWBytes(), (long)rawMessage.getGWBytes().length);
        }
        catch (Exception ex) {
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: " + ex.getMessage());
            this.gateway.updateGateway();
            _logger.error("Error,", (Throwable)ex);
        }
    }

    @Override
    public void close() {
        if (this.serialPort.closePort()) {
            _logger.debug("serialPort{} closed", (Object)this.serialPort.getDescriptivePortName());
        } else {
            _logger.warn("Failed to close serialPort{}", (Object)this.serialPort.getDescriptivePortName());
        }
    }

    private void initialize() {
        SerialPort[] serialPorts = SerialPort.getCommPorts();
        _logger.debug("Number of serial port available:{}", (Object)serialPorts.length);
        for (int portNo = 0; portNo < serialPorts.length; ++portNo) {
            _logger.debug("SerialPort[{}]:[{},{}]", new Object[]{portNo + 1, serialPorts[portNo].getSystemPortName(), serialPorts[portNo].getDescriptivePortName()});
        }
        this.serialPort = SerialPort.getCommPort((String)this.gateway.getPortName());
        this.serialPort.openPort();
        if (!this.serialPort.isOpen()) {
            _logger.error("Unable to open serial port:[{}]", (Object)this.gateway.getPortName());
            this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: Unable to open!");
            this.gateway.updateGateway();
            return;
        }
        this.serialPort.setComPortParameters(this.gateway.getBaudRate().intValue(), 8, 1, 0);
        this.serialPort.addDataListener((SerialPortDataListener)new SerialDataListenerjSerialComm(this.serialPort, this.gateway));
        _logger.debug("Serial port initialized with {}", (Object)this.gateway.getConnectionDetails());
        this.gateway.setStatus(AppProperties.STATE.UP, "Connected Successfully");
        this.gateway.updateGateway();
    }

    @Override
    public GatewaySerial getGateway() {
        return this.gateway;
    }
}

