/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.jobs;

import java.util.List;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Timer;
import org.mycontroller.standalone.scheduler.SchedulerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageSunRiseSetJobs
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(ManageSunRiseSetJobs.class);

    private void unloadLoadSunRiseSetJobs() {
        List<Timer> timers = DaoUtils.getTimerDao().getAllEnabled();
        for (Timer timer : timers) {
            switch (timer.getTimerType()) {
                case BEFORE_SUNRISE: 
                case AFTER_SUNRISE: 
                case BEFORE_SUNSET: 
                case AFTER_SUNSET: {
                    SchedulerUtils.reloadTimerJob(timer);
                    break;
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            this.unloadLoadSunRiseSetJobs();
            _logger.debug("SunRise, SunSet jobs reseting completed...");
        }
        catch (Exception ex) {
            _logger.error("exception, ", (Throwable)ex);
        }
    }
}

