/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.uidtag;

public class UidTagMapper {
    private boolean query;
    private Integer uid;
    private String payload;

    public UidTagMapper() {
    }

    public UidTagMapper(String uidString) {
        String[] uidArray = uidString.split("\\|");
        if (uidArray.length != 4) {
            throw new IllegalArgumentException("uidString should have exactly four values with spliter[|], received: " + uidString);
        }
        this.uid = Integer.valueOf(uidArray[1].trim());
        this.query = uidArray[2].trim().equalsIgnoreCase("0");
        this.payload = uidArray[3].trim();
    }

    public UidTagMapper(boolean request, Integer uid, String payload) {
        this.query = request;
        this.uid = uid;
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public boolean isQuery() {
        return this.query;
    }

    public void setQuery(boolean request) {
        this.query = request;
    }

    public Integer getUid() {
        return this.uid;
    }

    public void setUid(Integer uid) {
        this.uid = uid;
    }

    public String getUidTagRawMessage() {
        StringBuilder builder = new StringBuilder("uid");
        builder.append(",").append(this.uid);
        builder.append(",").append(this.isQuery() ? "0" : "1");
        builder.append(",").append(this.payload);
        return builder.toString();
    }
}

