/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.api.jaxrs.mapper.ApiError;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.DeleteResourceUtils;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.db.tables.Node;

@Path(value="/rest/nodes")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NodeHandler {
    @GET
    @Path(value="/")
    public Response getAllNodes(@QueryParam(value="gatewayId") Integer gatewayId, @QueryParam(value="gatewayName") List<String> gatewayName, @QueryParam(value="type") String type, @QueryParam(value="state") String state, @QueryParam(value="eui") List<String> eui, @QueryParam(value="name") List<String> name, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("gatewayId", gatewayId);
        filters.put("gatewayName", gatewayName);
        filters.put("type", (Object)MYCMessages.MESSAGE_TYPE_PRESENTATION.fromString(type));
        filters.put("state", (Object)AppProperties.STATE.fromString(state));
        filters.put("eui", eui);
        filters.put("name", name);
        QueryResponse queryResponse = DaoUtils.getNodeDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @GET
    @Path(value="/{nodeId}")
    public Response get(@PathParam(value="nodeId") Integer nodeId) {
        Node node = DaoUtils.getNodeDao().get(nodeId);
        return RestUtils.getResponse(Response.Status.OK, node);
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Integer id) {
        Node node = DaoUtils.getNodeDao().get(id);
        DeleteResourceUtils.deleteNode(node);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @POST
    @Path(value="/deleteIds")
    public Response deleteIds(List<Integer> ids) {
        DeleteResourceUtils.deleteNodes(ids);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @PUT
    @Path(value="/")
    public Response update(Node node) {
        ObjectFactory.getIActionEngine(node.getGateway().getNetworkType()).updateNode(node);
        return RestUtils.getResponse(Response.Status.NO_CONTENT);
    }

    @POST
    @Path(value="/")
    public Response add(Node node) {
        Gateway gateway = (Gateway)DaoUtils.getGatewayDao().getById(node.getGateway().getId());
        node.setGateway(gateway);
        ObjectFactory.getIActionEngine(node.getGateway().getNetworkType()).addNode(node);
        return RestUtils.getResponse(Response.Status.CREATED);
    }

    @POST
    @Path(value="/reboot")
    public Response reboot(List<Integer> ids) {
        List<Node> nodes = DaoUtils.getNodeDao().get(ids);
        if (nodes != null && nodes.size() > 0) {
            for (Node node : nodes) {
                ObjectFactory.getIActionEngine(node.getGateway().getNetworkType()).rebootNode(node);
            }
            return RestUtils.getResponse(Response.Status.OK);
        }
        return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("Selected Node(s) not available! Number of nodes:[" + nodes.size() + "]"));
    }

    @POST
    @Path(value="/uploadFirmware")
    public Response uploadFirmware(List<Integer> ids) {
        List<Node> nodes = DaoUtils.getNodeDao().get(ids);
        if (nodes != null && nodes.size() > 0) {
            for (Node node : nodes) {
                if (node.getFirmware() == null) continue;
                ObjectFactory.getIActionEngine(node.getGateway().getNetworkType()).uploadFirmware(node);
            }
            return RestUtils.getResponse(Response.Status.OK);
        }
        return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("Selected Node(s) not available! Node Ids:[" + ids + "]"));
    }

    @POST
    @Path(value="/eraseConfiguration")
    public Response eraseConfig(List<Integer> ids) {
        List<Node> nodes = DaoUtils.getNodeDao().get(ids);
        if (nodes != null && nodes.size() > 0) {
            for (Node node : nodes) {
                ObjectFactory.getIActionEngine(node.getGateway().getNetworkType()).eraseConfiguration(node);
            }
            return RestUtils.getResponse(Response.Status.OK);
        }
        return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("Selected Node not available! Node Ids:[" + ids + "]"));
    }
}

