/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.api.jaxrs.mapper.ApiError;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.ResourcesLogsUtils;
import org.mycontroller.standalone.db.tables.ResourcesLogs;

@Path(value="/rest/resources/logs")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"admin"})
public class ResourcesLogsHandler {
    @GET
    @Path(value="/")
    public Response getAll(@QueryParam(value="resourceType") String resourceType, @QueryParam(value="resourceId") Integer resourceId, @QueryParam(value="messageType") String messageType, @QueryParam(value="message") List<String> message, @QueryParam(value="logDirection") String logDirection, @QueryParam(value="pageLimit") Long pageLimit, @QueryParam(value="page") Long page, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="order") String order) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("resourceType", (Object)AppProperties.RESOURCE_TYPE.fromString(resourceType));
        filters.put("resourceId", resourceId);
        filters.put("messageType", (Object)MYCMessages.MESSAGE_TYPE.fromString(messageType));
        filters.put("message", message);
        filters.put("logDirection", (Object)ResourcesLogsUtils.LOG_DIRECTION.fromString(logDirection));
        QueryResponse queryResponse = DaoUtils.getResourcesLogsDao().getAll(Query.builder().order(order != null ? order : "asc").orderBy(orderBy != null ? orderBy : "id").filters(filters).pageLimit(pageLimit != null ? pageLimit : Query.MAX_ITEMS_PER_PAGE).page(page != null ? page : 1L).build());
        return RestUtils.getResponse(Response.Status.OK, queryResponse);
    }

    @PUT
    @Path(value="/")
    public Response purge(ResourcesLogs resourcesLogs) {
        if (resourcesLogs.getTimestamp() == null) {
            return RestUtils.getResponse(Response.Status.BAD_REQUEST, new ApiError("at least 'timestamp' is required to purge."));
        }
        DaoUtils.getResourcesLogsDao().deleteAll(null, resourcesLogs.getTimestamp());
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/delete")
    public Response purge(List<Integer> ids) {
        DaoUtils.getResourcesLogsDao().delete(ids);
        return RestUtils.getResponse(Response.Status.OK);
    }
}

