/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db;

import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.db.PayloadOperationUtils;

public class PayloadOperation {
    private PayloadOperationUtils.SEND_PAYLOAD_OPERATIONS operationType;
    private Double value;
    private String payload;

    public PayloadOperation(String payload) {
        this.payload = payload;
        this.operationType = PayloadOperationUtils.SEND_PAYLOAD_OPERATIONS.fromString(payload.toLowerCase().trim());
        if (this.operationType == null) {
            this.operationType = PayloadOperationUtils.SEND_PAYLOAD_OPERATIONS.fromString(payload.substring(0, 1).toLowerCase());
            if (this.operationType != null) {
                this.value = NumericUtils.getDouble(payload.substring(1));
                this.payload = NumericUtils.getDoubleAsString(this.value);
            }
        }
    }

    public Double getValue() {
        return this.value;
    }

    public PayloadOperationUtils.SEND_PAYLOAD_OPERATIONS getOperationType() {
        return this.operationType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Operation:").append(this.operationType.getText());
        builder.append(", Value:").append(this.value);
        builder.append(", Payload:").append(this.payload);
        return builder.toString();
    }

    public String getPayload() {
        return this.payload;
    }
}

