/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.dao.AlarmDefinitionDao;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.tables.AlarmDefinition;

public class AlarmDefinitionDaoImpl
extends BaseAbstractDaoImpl<AlarmDefinition, Integer>
implements AlarmDefinitionDao {
    public AlarmDefinitionDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, AlarmDefinition.class);
    }

    @Override
    public void delete(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        try {
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("resourceType", (Object)resourceType).and().eq("resourceId", (Object)resourceId);
            Integer count = deleteBuilder.delete();
            _logger.debug("deleted alarms with Resource:[Type:{}, KEY_ID:{}], Deletion Count:{}", new Object[]{resourceType.getText(), resourceId, count});
        }
        catch (SQLException ex) {
            _logger.error("unable to delete alarms with Resource:[Type:{}, KEY_ID:{}]", new Object[]{resourceType.getText(), resourceId, ex});
        }
    }

    @Override
    public List<AlarmDefinition> getAll(AppProperties.RESOURCE_TYPE resourceType) {
        return this.getAll(resourceType, null);
    }

    @Override
    public List<AlarmDefinition> getAll(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        return this.getAll(resourceType, resourceId, null);
    }

    @Override
    public List<AlarmDefinition> getAllEnabled(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        return this.getAll(resourceType, resourceId, true);
    }

    @Override
    public List<AlarmDefinition> getAll(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId, Boolean enabled) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            Where where = queryBuilder.where();
            where.eq("resourceType", (Object)resourceType);
            if (enabled != null) {
                where.and().eq("enabled", (Object)enabled);
            }
            if (resourceId != null) {
                where.and().eq("resourceId", (Object)resourceId);
            }
            queryBuilder.setWhere(where);
            List alarmDefinitions = this.getDao().query(queryBuilder.prepare());
            return alarmDefinitions;
        }
        catch (SQLException ex) {
            _logger.error("unable to get all alarms:[Resource:[Type:{},KEY_ID:{}], Enabled:{}]", new Object[]{resourceType.getText(), resourceId, enabled, ex});
            return null;
        }
    }

    @Override
    public void disableAllTriggered() {
        try {
            UpdateBuilder updateBuilder = this.getDao().updateBuilder();
            updateBuilder.updateColumnValue("triggered", (Object)false).where().eq("triggered", (Object)true);
            Integer count = updateBuilder.update();
            _logger.debug("Number of rows updated:[{}]", (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to update alarm triggered status", (Throwable)ex);
        }
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }

    @Override
    public AlarmDefinition get(AlarmDefinition alarmDefinition) {
        return (AlarmDefinition)this.getById(alarmDefinition.getId());
    }

    @Override
    public List<AlarmDefinition> getAll(List<Integer> ids) {
        return this.getAll("id", ids);
    }

    @Override
    public long countOf(AppProperties.RESOURCE_TYPE resourceType, Integer resourceId) {
        return this.countOf(resourceType, Arrays.asList(resourceId));
    }

    @Override
    public long countOf(AppProperties.RESOURCE_TYPE resourceType, List<Integer> resourceIds) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("resourceType", (Object)resourceType).and().in("resourceId", resourceIds);
            return queryBuilder.countOf();
        }
        catch (SQLException ex) {
            _logger.error("unable to get alarm definitions count for resource[Type:{}, Id:{}]", new Object[]{resourceType, resourceIds, ex});
            return 0L;
        }
    }

    @Override
    public List<AlarmDefinition> getAll(AlarmUtils.DAMPENING_TYPE dampeningType) {
        return this.getAll("dampeningType", (Object)dampeningType);
    }
}

