/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.db.DbException;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.SensorVariableDao;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.metrics.MetricsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorVariableDaoImpl
extends BaseAbstractDaoImpl<SensorVariable, Integer>
implements SensorVariableDao {
    private static final Logger _logger = LoggerFactory.getLogger(SensorVariableDaoImpl.class);

    public SensorVariableDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, SensorVariable.class);
    }

    @Override
    public void create(SensorVariable sensorVariable) {
        try {
            this.nodeIdSensorIdnullCheck(sensorVariable);
            Integer count = this.getDao().create((Object)sensorVariable);
            _logger.debug("Created SensorVariable:[{}], Create count:{}", (Object)sensorVariable, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add SensorVariable:[{}]", (Object)sensorVariable, (Object)ex);
        }
        catch (DbException dbEx) {
            _logger.error("unable to create, sensorValue:{}", (Object)sensorVariable, (Object)dbEx);
        }
    }

    @Override
    public void createOrUpdate(SensorVariable sensorVariable) {
        try {
            this.nodeIdSensorIdnullCheck(sensorVariable);
            Dao.CreateOrUpdateStatus status = this.getDao().createOrUpdate((Object)sensorVariable);
            _logger.debug("CreateOrUpdate SensorVariable:[{}],Create:{},Update:{},Lines Changed:{}", new Object[]{sensorVariable, status.isCreated(), status.isUpdated(), status.getNumLinesChanged()});
        }
        catch (SQLException ex) {
            _logger.error("CreateOrUpdate failed, SensorVariable:[{}]", (Object)sensorVariable, (Object)ex);
        }
        catch (DbException dbEx) {
            _logger.error("unable to createOrUpdate, sensorValue:{}", (Object)sensorVariable, (Object)dbEx);
        }
    }

    @Override
    public void delete(SensorVariable sensorVariable) {
        try {
            int deleteCount = this.getDao().delete((Object)sensorVariable);
            _logger.debug("Deleted senosor:[{}], delete count:{}", (Object)sensorVariable, (Object)deleteCount);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete, sensorValue:{}", (Object)sensorVariable, (Object)ex);
        }
    }

    @Override
    public void update(SensorVariable sensorVariable) {
        try {
            this.nodeIdSensorIdnullCheck(sensorVariable);
            UpdateBuilder updateBuilder = this.getDao().updateBuilder();
            updateBuilder.updateColumnValue("unit", (Object)sensorVariable.getUnit());
            if (sensorVariable.getValue() != null) {
                updateBuilder.updateColumnValue("value", (Object)sensorVariable.getValue());
            }
            if (sensorVariable.getTimestamp() != null) {
                updateBuilder.updateColumnValue("timestamp", (Object)sensorVariable.getTimestamp());
            }
            if (sensorVariable.getMetricType() != null) {
                updateBuilder.updateColumnValue("metricType", (Object)sensorVariable.getMetricType());
            }
            if (sensorVariable.getVariableType() != null) {
                updateBuilder.updateColumnValue("variableType", (Object)sensorVariable.getVariableType());
            }
            if (sensorVariable.getId() != null) {
                updateBuilder.where().eq("id", (Object)sensorVariable.getId());
            } else {
                updateBuilder.where().eq("sensorDbId", (Object)sensorVariable.getSensor().getId()).and().eq("variableType", (Object)sensorVariable.getVariableType());
            }
            int updateCount = updateBuilder.update();
            _logger.debug("Updated senosorValue:[{}], update count:{}", (Object)sensorVariable, (Object)updateCount);
        }
        catch (SQLException ex) {
            _logger.error("unable to get", (Throwable)ex);
        }
        catch (DbException dbEx) {
            _logger.error("unable to update, sensorValue:{}", (Object)sensorVariable, (Object)dbEx);
        }
    }

    @Override
    public List<SensorVariable> getAll(Integer sensorRefId) {
        try {
            if (sensorRefId == null) {
                return new ArrayList<SensorVariable>();
            }
            return this.getDao().queryForEq("sensorDbId", (Object)sensorRefId);
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list wit sensorRefId:{}", (Object)sensorRefId, (Object)ex);
            return null;
        }
    }

    @Override
    public List<SensorVariable> getByVariableType(MYCMessages.MESSAGE_TYPE_SET_REQ variableType) {
        try {
            if (variableType == null) {
                return null;
            }
            return this.getDao().queryForEq("variableType", (Object)variableType);
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list with variableType: {}", (Object)variableType, (Object)ex);
            return null;
        }
    }

    @Override
    public List<SensorVariable> getAllDoubleMetric(Integer sensorRefId) {
        try {
            if (sensorRefId == null) {
                return null;
            }
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("sensorDbId", (Object)sensorRefId).and().eq("metricType", (Object)MetricsUtils.METRIC_TYPE.DOUBLE);
            return queryBuilder.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list with sensorRefId:{}, MetricType:{}", new Object[]{sensorRefId, MetricsUtils.METRIC_TYPE.DOUBLE, ex});
            return null;
        }
    }

    @Override
    public List<SensorVariable> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public SensorVariable get(Integer sensorRefId, MYCMessages.MESSAGE_TYPE_SET_REQ messageVariableType) {
        try {
            this.nodeIdSensorIdnullCheck(sensorRefId, messageVariableType);
            return (SensorVariable)this.getDao().queryForFirst(this.getDao().queryBuilder().where().eq("sensorDbId", (Object)sensorRefId).and().eq("variableType", (Object)messageVariableType).prepare());
        }
        catch (SQLException ex) {
            _logger.error("unable to get", (Throwable)ex);
        }
        catch (DbException dbEx) {
            _logger.error("unable to get, nodeId:{},sensorId:{}", new Object[]{sensorRefId, messageVariableType, dbEx});
        }
        return null;
    }

    @Override
    public SensorVariable get(SensorVariable sensorVariable) {
        try {
            if (sensorVariable.getId() != null) {
                return (SensorVariable)this.getDao().queryForId((Object)sensorVariable.getId());
            }
            return this.get(sensorVariable.getSensor().getId(), sensorVariable.getVariableType());
        }
        catch (SQLException ex) {
            _logger.error("unable to get", (Throwable)ex);
            return null;
        }
    }

    @Override
    public SensorVariable get(int id) {
        try {
            return (SensorVariable)this.getDao().queryForId((Object)id);
        }
        catch (SQLException ex) {
            _logger.error("unable to get", (Throwable)ex);
            return null;
        }
    }

    private void nodeIdSensorIdnullCheck(Integer sensorRefId, MYCMessages.MESSAGE_TYPE_SET_REQ messageVariableType) throws DbException {
        if (sensorRefId != null && messageVariableType != null) {
            return;
        }
        throw new DbException("SensorId or NodeId should not be a NULL, sensorRefId:" + sensorRefId + ",messageVariableTypeId:" + (Object)((Object)messageVariableType));
    }

    private void nodeIdSensorIdnullCheck(SensorVariable sensorVariable) throws DbException {
        if (sensorVariable != null && sensorVariable.getSensor() != null && sensorVariable.getVariableType() != null) {
            return;
        }
        throw new DbException("SensorVariable or Sensor or VariableType should not be a NULL, SensorVariable:" + sensorVariable);
    }

    @Override
    public List<Integer> getSensorVariableIds(Integer sensorRefId) {
        List<SensorVariable> variables = this.getAll(sensorRefId);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SensorVariable sensorVariable : variables) {
            ids.add(sensorVariable.getId());
        }
        return ids;
    }
}

